/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>
#include <unistd.h>

#include "mserver.h"

extern FILE *outsock;
extern int cspeed;

extern struct msrv_client *clients[MAXCLIENTS];

void mserver_capture (const char *capname)
{
	if (!auth_check("capture", AUTH_CONNECT))
	{
		fprintf(outsock, "ERROR: You are not authorized to capture the modem!\n");
		return;
	}

	if (getstat())
	{
		char cname[1024];
	
		cfile_getcname(cname);	

		fprintf(outsock, "ERROR: Connected to %s at %d\n", cname, shmem_get_cspeed());
		return;
	}

	shmem_set_capname(capname);
	shmem_set_captured(true);
	cfile_write(capname);
	fprintf(outsock, "CAPTURED\n");
}

void mserver_release ()
{
	if (!auth_check("capture", AUTH_DISCONNECT))
	{
		fprintf(outsock, "ERROR: You are not authorized to capture the modem!\n");
		return;
	}

	if (!shmem_get_captured())
	{
		fprintf(outsock, "ERROR: Modem is not captured!\n");
		return;
	}

	shmem_set_capname("");
	shmem_set_captured(false);
	fprintf(outsock, "RELEASED\n");
}
