(* Network address handling module.

This file is part of Liece.                                          

Author: Daiki Ueno <daiki@kake.info.waseda.ac.jp>                    
Created: 1998-09-28                                               
Revised: 1999-01-28                                               
Keywords: IRC, liece, DCC                                        

This program is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2, or (at your option)  
any later version.                                                   
                                                                      
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the      
GNU General Public License for more details.                         
                                                                      
You should have received a copy of the GNU General Public License    
along with GNU Emacs; see the file COPYING.  If not, write to the    
Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
Boston, MA 02111-1307, USA.  *)

val encode : string -> string;;
    (* [Naddr.encode s] encodes the XXX.XXX.XXX.XXX address [s] into
       another string packed by network byte order. *)

val decode : string -> string;;
    (* [Naddr.decode s] does the inverse job than [Naddr.encode],
       restoring initial expression of address. *)
