AC_DEFUN(AM_PATH_LISPDIR,
 [dnl #
  dnl # Check Emacs
  dnl #
  AC_ARG_WITH(emacs,
    [  --with-emacs=EMACS      compile with EMACS [EMACS=emacs, xemacs...]],
    [case "${withval}" in
       yes)	EMACS= ;;
       no)	AC_MSG_ERROR([emacs is not available]) ;;
       *)	EMACS=${withval} ;;
     esac], EMACS=)
  if test "x$EMACS" = "xt" -o "x$EMACS" = x; then
    AC_PATH_PROGS(EMACS, emacs xemacs mule, no)
  else
    AC_MSG_CHECKING(for emacs)
    AC_MSG_RESULT($EMACS)
  fi
  dnl # 
  dnl # Check Emacs directories
  dnl #
  AC_ARG_WITH(emacsdir,
    [  --with-emacsdir=EDIR    Emacs program/data files in EDIR [guessed]],
    [case "${withval}" in
       yes)	emacsdir=NONE ;;
       no)	AC_MSG_ERROR(emacsdir is not available) ;;
       *)	emacsdir=${withval} ;;
     esac], emacsdir=NONE)
  AC_MSG_CHECKING([where emacs files are in])
  AC_MSG_RESULT($emacsdir)
  AC_SUBST(emacsdir)
  dnl # 
  dnl # Check Emacs site-lisp directories
  dnl #
  ac_cv_lispdir=no
  AC_ARG_WITH(lispdir,
    [  --with-lispdir=DIR      emacs lisp files in DIR [EDIR/site-lisp]],
    [case "${withval}" in
       yes)	lispdir=NONE ;;
       no)	AC_MSG_ERROR(lispdir is not available) ;;
       *)	lispdir=${withval} ; ac_cv_lispdir=yes ;;
     esac], lispdir=NONE)
  AC_MSG_CHECKING([where .elc files should go])
  AC_MSG_RESULT($lispdir)
  AC_SUBST(lispdir)
  AM_CONDITIONAL(USE_CUSTOM_LISPDIR, test x$ac_cv_lispdir = xyes)
  dnl #
  dnl # Check whether install as XEmacs package
  dnl #
  AC_ARG_ENABLE(package,
    [  --enable-package        install as XEmacs package [default=no]],,
    enable_package=no)
  AC_MSG_CHECKING([whether install as XEmacs package])
  if test "x$enable_package" = "xyes"; then
    AC_MSG_RESULT(yes)
    EMACS=xemacs
    dnl # 
    dnl # Check XEmacs package directories 
    dnl #
    ac_cv_packagedir=no
    AC_ARG_WITH(packagedir,
      [  --with-packagedir=DIR   XEmacs package files in DIR [EDIR/packages]],
      [case "${withval}" in
         yes)	packagedir=NONE ;;
         no)	AC_MSG_ERROR(packagedir is not available) ;;
         *)	packagedir=${withval} ; ac_cv_packagedir=yes ;;
       esac], packagedir=NONE)
    AC_MSG_CHECKING([where package files should go])
    if test "x$packagedir" = "xNONE"; then
      eval `$EMACS -batch -q -no-site-file -l ./lisp/liece-make.el \
        -f config-liece-package-directory`
      packagedir=$PACKAGEDIR
    fi
    AC_MSG_RESULT($packagedir)
    AC_SUBST(packagedir)
    AM_CONDITIONAL(USE_CUSTOM_PACKAGEDIR, test x$ac_cv_packagedir = xyes)
  else 
    AC_MSG_RESULT(no)
  fi
  AM_CONDITIONAL(USE_PACKAGE, test x$enable_package = xyes)])
