/*
 ui-hilight-text.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static gboolean hilight_next;

static gboolean sig_print_text(SERVER_REC *server, gchar *channel, gpointer level, gchar *str)
{
    if (!hilight_next)
	return TRUE;

    hilight_next = FALSE;
    return FALSE;
}

static gboolean sig_print_text_stripped(SERVER_REC *server, gchar *channel, gpointer level, gchar *str)
{
    GList *tmp;
    gchar *s, *key;
    gint lev;

    g_return_val_if_fail(str != NULL, FALSE);

    lev = GPOINTER_TO_INT(level);

    /* check only msgs/notices/actions */
    if ((lev & (MSGLEVEL_NOHILIGHT|MSGLEVEL_HILIGHT)) || (lev & (MSGLEVEL_PUBLIC | MSGLEVEL_MSGS | MSGLEVEL_NOTICES | MSGLEVEL_ACTIONS)) == 0)
	return TRUE;

    s = g_strdup(str); g_strup(s);
    for (tmp = g_list_first(hilights); tmp != NULL; tmp = tmp->next)
    {
        LIST_REC *rec = tmp->data;

        if (*rec->value != '\0' && !find_substr(rec->value, channel))
            continue;

        key = g_strdup(rec->key); g_strup(key);
        if (strstr(s, key) != NULL)
        {
            /* hilight! */
            break;
        }
        g_free(key);
    }
    g_free(s);

    if (tmp != NULL)
    {
	hilight_next = FALSE;
	s = g_strdup_printf("\004\377\001%s", str);
	signal_emit("print text", 4, server, channel, GINT_TO_POINTER(GPOINTER_TO_INT(level) | MSGLEVEL_HILIGHT), s);
	g_free(s);
	hilight_next = TRUE;
    }

    return TRUE;
}

void ui_hilight_text_init(void)
{
    hilight_next = FALSE;

    signal_add_first("print text", (SIGNAL_FUNC) sig_print_text);
    signal_add_first("print text stripped", (SIGNAL_FUNC) sig_print_text_stripped);
}

void ui_hilight_text_deinit(void)
{
    signal_remove("print text", (SIGNAL_FUNC) sig_print_text);
    signal_remove("print text stripped", (SIGNAL_FUNC) sig_print_text_stripped);
}
