/*
 ui-channels.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static gboolean sig_autorun(void)
{
    GString *buf, *out;
    gchar *path;
    gint f;

    /* open ~/.irssi/startup and run all commands in it */
    path = g_strdup_printf("%s/.irssi/startup", g_get_home_dir());
    f = open(path, O_RDONLY);
    g_free(path);
    if (f == -1)
    {
	/* file not found */
	return TRUE;
    }

    out = g_string_new(NULL);
    buf = g_string_new(NULL);
    while (read_line(FALSE, f, out, buf) > 0)
	signal_emit("send command", 3, out->str, cur_channel->server, cur_channel);
    g_string_free(out, TRUE);
    g_string_free(buf, TRUE);

    close(f);

    return TRUE;
}

void ui_autorun_init(void)
{
    signal_add_last("irssi init finished", (SIGNAL_FUNC) sig_autorun);
}

void ui_autorun_deinit(void)
{
    signal_remove("irssi init finished", (SIGNAL_FUNC) sig_autorun);
}
