#ifndef __LOG_H
#define __LOG_H

typedef struct
{
    gchar *name; /* channel or nick */
    gint level; /* logging level for this item */
}
LOG_ITEM_REC;

typedef struct
{
    gchar *fname;
    gboolean autoopen_log;

    gint handle;
    time_t last;

    gint level;
    GList *items;
}
LOG_REC;

extern GList *logs;

LOG_REC *log_create(gchar *fname, gchar *data);
LOG_REC *log_create_with_level(gchar *fname, gint level);
void log_file_destroy(LOG_REC *log);
LOG_REC *log_file_find(gchar *fname);

gboolean log_file_open(LOG_REC *log);
void log_file_close(LOG_REC *log);

void log_append_item(LOG_REC *log, gchar *name, gint level);
void log_remove_item(LOG_REC *log, gchar *name);

void log_init(void);
void log_deinit(void);

#endif
