#ifndef __SIGNAL_H
#define __SIGNAL_H

/* returning FALSE causes signal to terminate */
typedef gboolean (*SIGNAL_FUNC) (gpointer, gpointer, gpointer, gpointer, gpointer, gpointer, gpointer);

void signals_init(void);
void signals_deinit(void);

void signal_add(gchar *signal, SIGNAL_FUNC func);
void signal_add_first(gchar *signal, SIGNAL_FUNC func);
void signal_add_last(gchar *signal, SIGNAL_FUNC func);
void signal_remove(gchar *signal, SIGNAL_FUNC func);

gboolean signal_emit(gchar *signal, gint params, ...);

#endif
