#ifndef __SERVER_H
#define __SERVER_H

/*

Defines signals:

server_connect()
 "server looking", server_rec
 "server connecting", server_rec
 "server connected", server_rec
 "server connect failed", server_rec

server_disconnect()
 "server disconnected", server_rec

event_privmsg()
 "ctcp msg", message, server_rec, sender_nick, target

event_notice()
 "ctcp reply", message, server_rec, sender_nick, target

*/

typedef struct
{
    time_t connect_time; /* connection time */

    gchar *tag; /* tag name for addressing server */
    gchar *ircnet;
    gchar *password;

    gchar *address; /* server address */
    gchar *real_address; /* address the irc server gives */
    gint port; /* connected port */

    gchar *wanted_nick; /* nick we'd like to have. */
    gchar *nick; /* current nick */
    gchar *username;
    gchar *realname;

    gint connected; /* connected to server */
    gboolean connection_lost; /* Connection lost unintentionally */

    gint handle; /* socket handle */
    gint readtag; /* gui input tag */

    /* for net_connect_nonblock() */
    gint connect_pipe[2];
    gint connect_tag;
    gint connect_pid;

    guint names_coming:1; /* /NAMES list is coming .. */
    guint whois_coming:1; /* /WHOIS coming .. */
    guint emode_not_known:1; /* Server doesn't understand ban exceptions and invite lists */
    guint no_multi_mode:1; /* Server doesn't understand MODE #chan1,#chan2,... */
    guint no_multi_who:1; /* Server doesn't understand WHO #chan1,#chan2,... */
    guint one_endofwho:1; /* /WHO #a,#b,.. replies only with one End of WHO message */

    gint max_kicks_in_cmd; /* max. number of people to kick with one /KICK command */
    gint max_msgs_in_cmd; /* max. number of targets in one /MSG */
    gint max_modes_in_cmd; /* max. number of mode changes in one /MODE */

    gchar *usermode; /* The whole mode string .. */
    guint usermode_invisible:1;
    guint usermode_wallops:1;
    guint usermode_servernotes:1;
    guint usermode_away:1;

    GList *ctcpqueue; /* CTCP flood protection - list of tags in idle queue */
    GHashTable *floodlist; /* Flood protection */

    /* Auto ignore list */
    GList *ignorelist;
    time_t ignore_lastcheck;

    /* /knockout ban list */
    GList *knockoutlist;
    time_t knockout_lastcheck;

    /* Command sending queue */
    gint cmdcount; /* 0 = no commands to send, 1 = command was sent a while
                      ago, nothing in cmdqueue, >1 = cmdcount-1 commands in
                      cmdqueue */
    GList *cmdqueue;
    struct timeval last_cmd; /* last time command was sent to server */
    gint cmd_queue_speed; /* Timeout between sending commands */

    /* For deciding if event should be handled internally */
    GHashTable *eventtable; /* "event xxx" : GList* of REDIRECT_RECs */
    GHashTable *eventgrouptable; /* event group : GList* of REDIRECT_RECs */
    GHashTable *cmdtable; /* "command xxx" : REDIRECT_CMD_REC* */

    GList *idles; /* Idle queue - send these commands to server if there's
                     nothing else to do */

    GList *ison_users; /* List of users in notify list in IRC */
    GList *ison_tempusers; /* Temporary list for saving /ISON events.. */

    gint rawlog_lines; /* Lines in rawlog */
    GList *rawlog; /* Rawlog buffer */

    GHashTable *queries; /* "mode", "who", "bmode", "emode", "imode", GList* of CHANNEL_RECs */
    gchar *last_query_chan; /* channel of last query */

    GList *lastmsgs; /* List of nicks who last send you msg */
    GHashTable *splits; /* For keeping track of netsplits */
    GString *buffer; /* receive buffer */

    gboolean no_lag_check; /* don't try to detect lagging */
    time_t lag_sent; /* 0 or time when PING was sent to server */
    time_t lag_last_check; /* last time we checked lag */
    gint lag; /* server lag in milliseconds */

    gpointer gui_data;
}
SERVER_REC;

void servers_init(void);
void servers_deinit(void);

SERVER_REC *server_connect(gchar *address, gint port, gchar *password, gchar *nick);
void server_disconnect(SERVER_REC *server);

SERVER_REC *server_find_tag(gchar *tag);
SERVER_REC *server_find_ircnet(gchar *ircnet);

SETUP_SERVER_REC *server_setup_find(gchar *address, gint port);

extern GList *servers;

#endif
