#ifndef __COMMANDS_H
#define __COMMANDS_H

typedef struct
{
    gchar *category;
    gchar *cmd;
}
COMMAND_REC;

enum
{
    CMDERR_PARAM, /* invalid parameter */
    CMDERR_NOT_ENOUGH_PARAMS, /* not enough parameters given */
    CMDERR_NOT_CONNECTED, /* not connected to IRC server */
    CMDERR_NOT_JOINED, /* not joined to any channels in this window */
    CMDERR_GETSOCKNAME, /* getsockname() failed */
    CMDERR_LISTEN, /* listen() failed */
    CMDERR_MULTIPLE_MATCHES, /* multiple matches found, didn't do anything */
    CMDERR_NICK_NOT_FOUND, /* nick not found */
    CMDERR_CHAN_NOT_FOUND, /* channel not found */
    CMDERR_SERVER_NOT_FOUND, /* server not found */
    CMDERR_CHAN_NOT_SYNCED, /* channel not fully synchronized yet */
    CMDERR_NOT_GOOD_IDEA, /* not good idea to do, -yes overrides this */
};

#define cmd_return_error(a) { signal_emit("error command", 1, GINT_TO_POINTER(a)); return FALSE; }
#define cmd_param_error(a) { g_free(params); cmd_return_error(a); }

GList *commands;

void command_bind(gchar *cmd, gchar *category, SIGNAL_FUNC func);
void command_unbind(gchar *cmd, SIGNAL_FUNC func);

void command_runsub(gchar *cmd, gchar *data, SERVER_REC *server, CHANNEL_REC *channel);
void command_split(SERVER_REC *server, gchar *cmd, gint arg, gint max_nicks);

void commands_init(void);
void commands_deinit(void);

#endif
