#ifndef __CHANNELS_H
#define __CHANNELS_H

/*

Defines signals:

channel_create()
 "channel created", channel_rec

channel_destroy()
 "channel destroyed", channel_rec

channel_change_name()
 "channel name changed", channel_rec

*/

enum
{
    CHANNEL_TYPE_CHANNEL,
    CHANNEL_TYPE_QUERY,
    CHANNEL_TYPE_DCC_CHAT,
    CHANNEL_TYPE_EMPTY, /* When you type commands, there's always have to be
                           some channel where you type them from. If window
                           doesn't have any real channels, create ..EMPTY
                           channel there and when using /join when this
                           channel is focused, destroy it and replace it with
                           the new one. */
    CHANNEL_TYPE_SETUP
};

enum
{
    NEWDATA_TEXT = 1,
    NEWDATA_MSG,
    NEWDATA_MSG_FORYOU,
    NEWDATA_CUSTOM,
};

typedef struct
{
    SERVER_REC *server;
    time_t createtime;

    gchar *name;
    gint type;

    GHashTable *nicks; /* list of nicks */
    GList *banlist; /* list of bans */
    GList *ebanlist; /* list of ban exceptions */
    GList *invitelist; /* invite list */

    gchar *topic;
    gint limit; /* user limit */
    gchar *key; /* password key */

    gint level;
    gint new_data; /* NEWDATA_xxx */

    /* channel mode */
    guint mode_invite:1;
    guint mode_secret:1;
    guint mode_private:1;
    guint mode_moderate:1;
    guint mode_nomsgs:1;
    guint mode_optopic:1;
    guint mode_key:1;

    guint synced:1; /* Channel synced - all queries done */
    guint wholist:1; /* WHO list got */
    guint names_got:1; /* Received /NAMES list */
    guint chanop:1; /* You're a channel operator */
    guint left:1; /* You just left the channel */
    guint kicked:1; /* You just got kicked from here */

    GList *lastmsgs; /* List of nicks who last send message */
    GList *lastownmsgs; /* List of nicks who last send message to you */

    time_t massjoin_start; /* Massjoin start time */
    gint massjoins; /* Number of nicks waiting for massjoin signal.. */
    gint last_massjoins; /* Massjoins when last checked in timeout function */

    gpointer ui_data;
    gpointer gui_data;
}
CHANNEL_REC;

extern GList *channels;
extern CHANNEL_REC *cur_channel;

void channels_init(void);
void channels_deinit(void);

/* Create new channel record */
CHANNEL_REC *channel_create(SERVER_REC *server, gchar *channel, gint type);
void channel_destroy(CHANNEL_REC *channel);

void channel_change_name(CHANNEL_REC *channel, gchar *name);
CHANNEL_REC *channel_find(SERVER_REC *server, gchar *channel);
CHANNEL_REC *channel_find_closest(SERVER_REC *server, gchar *channel, gint level);
CHANNEL_REC *channel_find_any(gchar *channel);
CHANNEL_REC *channel_find_level(gint level);

gchar *channel_get_mode(CHANNEL_REC *channel);

#endif
