/*
 setup-appearance.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static GtkWidget *setup_dialog;

static gboolean sig_setup_apply(GtkWidget *dialog)
{
    setup_write("appearance", appearance_options);
    return TRUE;
}

static gboolean sig_setup_destroyed(void)
{
    setup_dialog = NULL;
    return TRUE;
}

static void sig_unlimited_channels(GtkWidget *button, GtkWidget *spin)
{
    GtkWidget *senswidget;

    senswidget = gtk_object_get_data(GTK_OBJECT(button), "senswidget");

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)))
    {
        gtk_widget_set_sensitive(senswidget, TRUE);
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), 99);
    }
    else
    {
        gtk_widget_set_sensitive(senswidget, FALSE);
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), -1.0);
    }
}

static void sig_use_itext(GtkWidget *button, GtkWidget *widget)
{
    gtk_widget_set_sensitive(widget, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)));
}

static gboolean setup_appearance(GtkWidget *dialog)
{
    GtkWidget *mainvbox, *frame, *hbox, *vbox, *vbox2;
    GtkWidget *checkbox, *spin, *label;
    GtkAdjustment *adj;

    setup_dialog = dialog;

    mainvbox = gtk_vbox_new(FALSE, 7);
    gtk_container_border_width(GTK_CONTAINER(mainvbox), 7);

    checkbox = gtk_check_button_new_with_label(_("Enable buggy GTK themes workaround, if enabled\nyou won't see nicks' gone-status in nicklist"));
    appearance_options[OPTION_BUGGY_GTKTHEMES].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(mainvbox), checkbox, FALSE, FALSE, 10);

    /* itext specific */
    frame = gtk_frame_new(_("Drawing method"));
    gtk_box_pack_start(GTK_BOX(mainvbox), frame, FALSE, FALSE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Use Irssi text widget for drawing texts"));
    appearance_options[OPTION_USE_ITEXT].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    vbox2 = gtk_vbox_new(FALSE, 0);
    gtk_widget_set_sensitive(vbox2, FALSE);
    gtk_box_pack_start(GTK_BOX(vbox), vbox2, FALSE, FALSE, 0);

    gtk_signal_connect(GTK_OBJECT(checkbox), "clicked",
                       GTK_SIGNAL_FUNC(sig_use_itext), vbox2);

    checkbox = gtk_check_button_new_with_label(_("Transparent background"));
    appearance_options[OPTION_BACKGROUND_TRANSPARENT].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox2), checkbox, FALSE, FALSE, 0);

    /* --- gnome panel --- */
    hbox = gtk_hbox_new(FALSE, 7);
    gtk_box_pack_start(GTK_BOX(mainvbox), hbox, FALSE, FALSE, 0);

    frame = gtk_frame_new(_("GNOME Panel"));
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Limit the number of channels shown in panel"));
    /* clicked signal.. -> */
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_widget_set_sensitive(hbox, FALSE);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) appearance_options[OPTION_PANEL_MAX_CHANNELS].data),
                                                -1, 99, 1, 5, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    appearance_options[OPTION_PANEL_MAX_CHANNELS].widget = spin;
    gtk_widget_set_usize(spin, 50, -1);
    gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 0);

    label = gtk_label_new(_("channels"));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    /* <- .. needs spin button as argument so placed here. */
    gtk_signal_connect(GTK_OBJECT(checkbox), "clicked",
		       GTK_SIGNAL_FUNC(sig_unlimited_channels), spin);
    gtk_object_set_data(GTK_OBJECT(checkbox), "senswidget", hbox);
    if (*((gint *) appearance_options[OPTION_PANEL_MAX_CHANNELS].data) != -1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), TRUE);

    setup_finish_init(dialog, appearance_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
				   mainvbox, gtk_label_new(_("Look #2")));
    return TRUE;
}

void init_appearance(void)
{
    signal_add("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup preferences destroyed", (SIGNAL_FUNC) sig_setup_destroyed);
    signal_add("setup preferences", (SIGNAL_FUNC) setup_appearance);
}

void deinit_appearance(void)
{
    signal_remove("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup preferences destroyed", (SIGNAL_FUNC) sig_setup_destroyed);
    signal_remove("setup preferences", (SIGNAL_FUNC) setup_appearance);
}
