#ifndef __GUI_SERVER_H
#define __GUI_SERVER_H

#define SERVER_GUI(a) ((GUI_SERVER_REC *) ((a)->gui_data))

typedef struct
{
    /* temporary space to save list (/list, /who, /whois ..) dialog, when
       "end of list" event is received, this should be set NULL */
    GtkWidget *listdialog;

    MAIN_WINDOW_REC *window;
    gint statusbar_id;
    gint userhost_tag;

    /* trying to keep track of who's gone and who's not.. */
    GList *gone_channel; /* position in channels */
    GList *gone_nicks; /* List of nicks - need to be freed! */

    GList *list; /* /LIST records */
    GList *wholist; /* /WHO records */
    GNode *links; /* /LINKS */

    GList *last_stats; /* queue for /STATS and /LINKS */
    gboolean stats_waiting; /* STATS/LINKS has been sent, waiting for reply.. */
}
GUI_SERVER_REC;

void gui_server_init(void);
void gui_server_deinit(void);

#endif
