/*
 dialog-channels.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

#include "dialog-connect.h"
#include "dialog-disconnect.h"
#include "dialog-channels.h"
#include "dialog-dcc.h"
#include "dialog-irssibot.h"
#include "dialog-join.h"
#include "dialog-links.h"
#include "dialog-log.h"
#include "dialog-modes.h"
#include "dialog-notifylist.h"
#include "dialog-plugins.h"
#include "dialog-rawlog.h"
#include "dialog-status.h"
#include "dialog-textwidget.h"
#include "dialog-window.h"

void dialogs_init(void)
{
    dialog_channels_init();
    dialog_connect_init();
    dialog_dcc_init();
    dialog_disconnect_init();
    dialog_irssibot_init();
    dialog_join_init();
    dialog_links_init();
    dialog_log_init();
    dialog_modes_init();
    dialog_notifylist_init();
    dialog_plugins_init();
    dialog_rawlog_init();
    dialog_status_init();
    dialog_textwidget_init();
    dialog_window_init();
}

void dialogs_deinit(void)
{
    dialog_channels_deinit();
    dialog_connect_deinit();
    dialog_dcc_deinit();
    dialog_disconnect_deinit();
    dialog_irssibot_deinit();
    dialog_join_deinit();
    dialog_links_deinit();
    dialog_log_deinit();
    dialog_modes_deinit();
    dialog_notifylist_deinit();
    dialog_plugins_deinit();
    dialog_rawlog_deinit();
    dialog_status_deinit();
    dialog_textwidget_deinit();
    dialog_window_deinit();
}
