/*
 gtk-external.c : GTK specific functions

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include <irssi-plugin-gui.h>
#include "external.h"

static GtkWidget *setup_dialog;

static gboolean sig_setup_apply(GtkWidget *dialog, PLUGIN_REC *plugin)
{
    setup_write("plugin_external", plugin_external_options);
    plugin_external_get_setup(plugin);
    return TRUE;
}

static gboolean setup_external(GtkWidget *dialog)
{
    GtkWidget *table, *entry;

    setup_dialog = dialog;

    table = gtk_table_new(3, 2, FALSE);
    gtk_container_border_width(GTK_CONTAINER(table), 7);
    gtk_table_set_col_spacing(GTK_TABLE(table), 0, 5);

    entry = gui_create_tablelabelentry(table, 0, 0, _("Named pipe path"),
                                       *((gchar **) plugin_external_options[OPTION_NAMED_PIPE_NAME].data));
    plugin_external_options[OPTION_NAMED_PIPE_NAME].widget = entry;

    setup_finish_init(dialog, plugin_external_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   table, gtk_label_new(_("External")));
    return TRUE;
}

static void plugin_setup(gpointer widget, PLUGIN_REC *plugin)
{
    static GtkWidget *dialog = NULL;

    setup("plugin external setup", &dialog, plugin);
}

void plugin_external_gtk_init(PLUGIN_REC *plugin)
{
    plugin_bind(plugin, "plugin external setup apply", (SIGNAL_FUNC) sig_setup_apply, FALSE);
    plugin_bind(plugin, "plugin external setup", (SIGNAL_FUNC) setup_external, FALSE);

    signal_emit("plugin add menu", 3, "Settings...", plugin_setup, plugin);
}
