#ifndef __BOT_USERS_H
#define __BOT_USERS_H

#define USER_OP         0x0001
#define USER_AUTO_OP    0x0002
#define USER_AUTO_VOICE 0x0004
#define USER_MASTER     0x0008

#define USER_FLAGS      4

/* Channel specific flags */
typedef struct
{
    gchar *channel;
    gint flags;
}
USER_CHAN_REC;

typedef struct
{
    gchar *mask;
    gint not_flags; /* do not let this mask use these flags.. */
}
USER_MASK_REC;

/* User specific flags */
typedef struct
{
    gchar *nick;
    gint flags;
    gchar *password;

    GList *masks;
    GHashTable *channels;

    gint not_flags; /* active not_flags based on current host mask,
                       botuser_find() updates this */
    NICK_REC *nickrec; /* Nick record in channel,
                          FIXME: multiple channel support!!!
			  User can be in channel with multiple nicks too! */
}
USER_REC;


USER_REC *botuser_find(gchar *nick, gchar *host);
USER_MASK_REC *botuser_add_mask(USER_REC *user, gchar *mask);

void botuser_set_password(USER_REC *user, gchar *password);
gboolean botuser_verify_password(USER_REC *user, gchar *password);

void plugin_bot_users_init(PLUGIN_REC *plugin);
void plugin_bot_users_deinit(PLUGIN_REC *plugin);

#endif
