#include "hx_types.h"
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "hx.h"
#include "htlc.h"
#include "dhargs.h"

extern int hx_sock;

u_int32_t hx_trans = 1;

void
htlc_snd_login (const char *login, const char *pass,
				const char *nick, u_int16_t icon)
{
	u_int8_t buf[1024];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));
	u_int16_t llen, plen, nlen, hc = 1;
	u_int32_t tot_len = 8;

	h->type = htonl(HTLC_HDR_LOGIN);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	dh->type = htons(HTLC_DATA_ICON);
	dh->len = htons(2);
	*((u_int16_t *)dh->data) = htons(icon);
	dh = (struct hx_data_hdr *)(&(buf[28]));

	if (login)
		llen = strlen(login);
	else
		llen = 0;
	if (pass)
		plen = strlen(pass);
	else
		plen = 0;
	if (nick)
		nlen = strlen(nick);
	else
		nlen = 0;

	if (llen) {
		register u_int16_t i;
		for (i = 0; i < llen; i++)
			dh->data[i] = (255 - login[i]);
		S16HTON(HTLC_DATA_LOGIN, &dh->type);
		S16HTON(llen, &dh->len);
		tot_len += 4 + llen;
		hc++;
		dh = (struct hx_data_hdr *)((u_int8_t *)dh + SIZEOF_HX_DATA_HDR + llen);
	}
	if (plen) {
		register u_int16_t i;
		for (i = 0; i < plen; i++)
			dh->data[i] = (255 - pass[i]);
		S16HTON(HTLC_DATA_PASSWORD, &dh->type);
		S16HTON(plen, &dh->len);
		tot_len += 4 + plen;
		hc++;
		dh = (struct hx_data_hdr *)((u_int8_t *)dh + SIZEOF_HX_DATA_HDR + plen);
	}
	if (nlen) {
		S16HTON(HTLC_DATA_NICK, &dh->type);
		S16HTON(nlen, &dh->len);
		memcpy(dh->data, nick, nlen);
		tot_len += 4 + nlen;
		hc++;
	}
	h->hc = htons(hc);
	h->len = h->len2 = htonl(tot_len);

	send(hx_sock, buf, (unsigned)(20 + tot_len), 0);
}

void
htlc_snd_news_getfile (void)
{
	struct hx_hdr h;

	h.type = htonl(HTLC_HDR_NEWS_GETFILE);
	h.trans = htonl(hx_trans++);
	h.flag = 0;
	h.len = h.len2 = htonl(2);
	h.hc = 0;

	send(hx_sock, &h, SIZEOF_HX_HDR, 0);
}

void
htlc_snd_user_getlist (void)
{
	struct hx_hdr h;

	h.type = htonl(HTLC_HDR_USER_GETLIST);
	h.trans = htonl(hx_trans++);
	h.flag = 0;
	h.len = h.len2 = htonl(2);
	h.hc = 0;

	send(hx_sock, &h, SIZEOF_HX_HDR, 0);
}

void
htlc_snd_chat (const void *data, u_int16_t len)
{
	u_int8_t buf[SIZEOF_HX_HDR + SIZEOF_HX_DATA_HDR];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(6 + len);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_CHAT);
	dh->len = htons(len);

	send(hx_sock, buf, SIZEOF_HX_HDR + SIZEOF_HX_DATA_HDR, 0);
	send(hx_sock, data, len, 0);
}

void
htlc_snd_chat_chat (u_int32_t pcref, const void *data, u_int16_t len)
{
	u_int8_t buf[SIZEOF_HX_HDR + (SIZEOF_HX_DATA_HDR * 2) + 4];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(14 + len);
	h->hc = htons(2);
	dh->type = htons(HTLC_DATA_CHAT);
	dh->len = htons(len);
	dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR + SIZEOF_HX_DATA_HDR]));
	dh->type = htons(HTLC_DATA_CHAT_REF);
	dh->len = htons(4);
	S32HTON(pcref, dh->data);

	send(hx_sock, buf, SIZEOF_HX_HDR + SIZEOF_HX_DATA_HDR, 0);
	send(hx_sock, data, len, 0);
	send(hx_sock, &(buf[SIZEOF_HX_HDR + SIZEOF_HX_DATA_HDR]), SIZEOF_HX_DATA_HDR + 4, 0);
}

void
htlc_snd_chat_chat_action (u_int32_t pcref, const void *data, u_int16_t len)
{
	u_int8_t buf[40];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(20 + len);
	h->hc = htons(3);
	dh->type = htons(HTLC_DATA_OPTION);
	dh->len = htons(2);
	*((u_int16_t *)dh->data) = htons(1);
	dh = (struct hx_data_hdr *)(&(buf[28]));
	dh->type = htons(HTLC_DATA_CHAT);
	dh->len = htons(len);
	dh = (struct hx_data_hdr *)(&(buf[32]));
	dh->type = htons(HTLC_DATA_CHAT_REF);
	dh->len = htons(4);
	S32HTON(pcref, dh->data);

	send(hx_sock, buf, 32, 0);
	send(hx_sock, data, len, 0);
	send(hx_sock, &(buf[32]), 8, 0);
}

void
htlc_snd_chat_create (u_int32_t sock)
{
	u_int8_t buf[30];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT_CREATE);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(10);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_SOCKET);
	dh->len = htons(4);
	S32HTON(sock, dh->data);

	send(hx_sock, buf, 30, 0);
}

void
htlc_snd_chat_invite (u_int32_t pcref, u_int32_t sock)
{
	u_int8_t buf[38];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT_INVITE);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(18);
	h->hc = htons(2);
	dh->type = htons(HTLC_DATA_CHAT_REF);
	dh->len = htons(4);
	S32HTON(pcref, dh->data);
	dh = (struct hx_data_hdr *)(&(buf[30]));
	dh->type = htons(HTLC_DATA_SOCKET);
	dh->len = htons(4);
	S32HTON(sock, dh->data);

	send(hx_sock, buf, 38, 0);
}

void
htlc_snd_chat_subject (u_int32_t pcref, const void *data, u_int16_t len)
{
	u_int8_t buf[34];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT_SUBJECT);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(14 + len);
	h->hc = htons(2);
	dh->type = htons(HTLC_DATA_CHAT_REF);
	dh->len = htons(4);
	S32HTON(pcref, dh->data);
	dh = (struct hx_data_hdr *)(&(buf[30]));
	dh->type = htons(HTLC_DATA_CHAT_SUBJECT);
	dh->len = htons(len);

	send(hx_sock, buf, 34, 0);
	send(hx_sock, data, len, 0);
}

void
htlc_snd_msg (u_int32_t sock, const void *data, u_int16_t len)
{
	u_int8_t buf[34];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_MSG);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(14 + len);
	h->hc = htons(2);
	dh->type = htons(HTLC_DATA_SOCKET);
	dh->len = htons(4);
	S32HTON(sock, dh->data);
	dh = (struct hx_data_hdr *)(&(buf[30]));
	dh->type = htons(HTLC_DATA_MSG);
	dh->len = htons(len);

	send(hx_sock, buf, 34, 0);
	send(hx_sock, data, len, 0);
}

void
htlc_snd_chat_join (u_int32_t pcref)
{
	u_int8_t buf[32];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT_JOIN);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(10);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_CHAT_REF);
	dh->len = htons(4);
	S32HTON(pcref, dh->data);

	send(hx_sock, buf, 30, 0);
}

void
htlc_snd_chat_decline (u_int32_t pcref)
{
	u_int8_t buf[30];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT_DECLINE);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(10);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_CHAT_REF);
	dh->len = htons(4);
	S32HTON(pcref, dh->data);

	send(hx_sock, buf, 30, 0);
}

void
htlc_snd_chat_leave (u_int32_t pcref)
{
	u_int8_t buf[30];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT_LEAVE);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(10);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_CHAT_REF);
	dh->len = htons(4);
	S32HTON(pcref, dh->data);

	send(hx_sock, buf, 30, 0);
}

void
htlc_snd_news_post (const void *data, u_int16_t len)
{
	u_int8_t buf[SIZEOF_HX_HDR + SIZEOF_HX_DATA_HDR];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_NEWS_POST);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(6 + len);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_NEWS_POST);
	dh->len = htons(len);

	send(hx_sock, buf, SIZEOF_HX_HDR + SIZEOF_HX_DATA_HDR, 0);
	send(hx_sock, data, len, 0);
}

void
htlc_snd_user_change (const u_int8_t *nick, u_int16_t nlen, u_int16_t icon)
{
	u_int8_t buf[32];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_USER_CHANGE);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(12 + nlen);
	h->hc = htons(2);
	dh->type = htons(HTLC_DATA_ICON);
	dh->len = htons(2);
	*((u_int16_t *)dh->data) = htons(icon);
	dh = (struct hx_data_hdr *)(&(buf[28]));
	dh->type = htons(HTLC_DATA_NICK);
	dh->len = htons(nlen);

	send(hx_sock, buf, 32, 0);
	send(hx_sock, nick, nlen, 0);
}

void
htlc_snd_chat_action (const void *data, u_int16_t len)
{
	u_int8_t buf[32];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_CHAT);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(12 + len);
	h->hc = htons(2);
	dh->type = htons(HTLC_DATA_OPTION);
	dh->len = htons(2);
	*((u_int16_t *)dh->data) = htons(1);
	dh = (struct hx_data_hdr *)(&(buf[28]));
	dh->type = htons(HTLC_DATA_CHAT);
	dh->len = htons(len);

	send(hx_sock, buf, 32, 0);
	send(hx_sock, data, len, 0);
}

void
htlc_snd_user_kickban (u_int32_t sock)
{
	u_int8_t buf[36];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_USER_KICK);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(16);
	h->hc = htons(2);
	dh->type = htons(HTLC_DATA_BAN);
	dh->len = htons(2);
	*((u_int16_t *)dh->data) = htons(1);
	dh = (struct hx_data_hdr *)(&(buf[28]));
	dh->type = htons(HTLC_DATA_SOCKET);
	dh->len = htons(4);
	*((u_int32_t *)dh->data) = htonl(sock);

	send(hx_sock, buf, 36, 0);
}

void
htlc_snd_user_kick (u_int32_t sock)
{
	u_int8_t buf[32];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_USER_KICK);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(10);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_SOCKET);
	dh->len = htons(4);
	S32HTON(sock, dh->data);

	send(hx_sock, buf, 30, 0);
}

void
htlc_snd_user_getinfo (u_int32_t sock)
{
	u_int8_t buf[32];
	struct hx_hdr *h = (struct hx_hdr *)buf;
	struct hx_data_hdr *dh = (struct hx_data_hdr *)(&(buf[SIZEOF_HX_HDR]));

	h->type = htonl(HTLC_HDR_USER_GETINFO);
	h->trans = htonl(hx_trans++);
	h->flag = 0;
	h->len = h->len2 = htonl(10);
	h->hc = htons(1);
	dh->type = htons(HTLC_DATA_SOCKET);
	dh->len = htons(4);
	S32HTON(sock, dh->data);

	send(hx_sock, buf, 30, 0);
}
