/*
 netload.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

NETLOAD_REC input, output;
NETLOAD_REC panelinput, paneloutput;
gint maxcps;

static int netload_expose(GtkWidget *widget, GdkEventExpose *event, GdkPixmap *pixmap)
{
    gdk_draw_pixmap(widget->window,
                    widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
                    pixmap,
                    event->area.x, event->area.y,
                    event->area.x, event->area.y,
                    event->area.width, event->area.height);
    return FALSE;
}

void netload_pixmap_new(GtkWidget *widget, NETLOAD_REC *rec, gint width, gint height)
{
    GdkColor color;
    GdkColormap *colormap;

    rec->disp = gtk_drawing_area_new();
    gtk_widget_set_usize(rec->disp, width, height);
    gtk_container_add(GTK_CONTAINER(widget), rec->disp);

    gtk_widget_realize(rec->disp);

    rec->pixmap = gdk_pixmap_new(rec->disp->window, width, height,
                            gtk_widget_get_visual(rec->disp)->depth);
    gdk_draw_rectangle(rec->pixmap, rec->disp->style->black_gc,
                       TRUE, 0,0, width, height);

    gtk_signal_connect(GTK_OBJECT(rec->disp), "expose_event",
                       GTK_SIGNAL_FUNC(netload_expose), rec->pixmap);

    colormap = gtk_widget_get_colormap(rec->disp);
    gdk_color_parse("#20b2aa", &color);
    gdk_color_alloc(colormap, &color);

    rec->gc = gdk_gc_new(rec->disp->window);
    gdk_gc_copy(rec->gc, rec->disp->style->white_gc);
    gdk_gc_set_foreground(rec->gc, &color);

    rec->data = g_new(gchar, width);
    memset(rec->data, height, width);
    rec->width = width; rec->height = height;
}

void netload_pixmap_destroy(NETLOAD_REC *rec)
{
    gtk_widget_destroy(rec->disp);
    if (rec->label != NULL) gtk_widget_destroy(rec->label);
    gdk_pixmap_unref(rec->pixmap);
    gdk_gc_unref(rec->gc);

    g_free(rec->data);
    g_free(rec);
}

static void draw_netload(NETLOAD_REC *rec, gint bgone)
{
    gint n;

    if (maxcps <= 0) return;

    if (bgone > maxcps || bgone < 0) bgone = maxcps;
    memmove(rec->data+1, rec->data, rec->width-1);
    rec->data[0] = rec->height - ((bgone * rec->height) / maxcps);

    gdk_draw_rectangle(rec->pixmap, rec->disp->style->black_gc,
                       TRUE, 0,0, rec->width, rec->height);

    for (n = 0; n < rec->width; n++)
        gdk_draw_line(rec->pixmap, rec->gc, n, rec->data[n], n, rec->height);

    gdk_draw_pixmap(rec->disp->window,
                    rec->disp->style->fg_gc[GTK_WIDGET_STATE(rec->disp)],
                    rec->pixmap, 0, 0, 0, 0, rec->width, rec->height);
}

void callback_netload(CALLBACK_DATA *data)
{
    static time_t lasttime = 0;
    gchar *parm, *sizestr, *str;
    gulong bytes, printsize, packets;
    gint timegone, bgone;
    NETLOAD_REC *rec;
#ifdef HAVE_GNOME_PANEL
    NETLOAD_REC *panelrec;
#endif

    if (data->status == 0)
    {
        callback_err = 1;
        return;
    }

    callback_err = 0;
    if (data->u.list.type == LIST_END)
        lasttime = time(NULL);
    else if (data->u.list.type == LIST_ITEM)
    {
        timegone = (int) (lasttime == 0 ? 1 : time(NULL) - lasttime);
        if (timegone == 0) return;

#ifdef HAVE_GNOME_PANEL
        panelrec = NULL;
#endif
        if (strncmp(data->u.list.data, "INPUT: ", 7) == 0)
        {
            rec = &input;
#ifdef HAVE_GNOME_PANEL
            if (applet_running && panel_show_input) panelrec = &panelinput;
#endif
            parm = data->u.list.data+7;
        }
        else if (strncmp(data->u.list.data, "OUTPUT: ", 8) == 0)
        {
            rec = &output;
#ifdef HAVE_GNOME_PANEL
            if (applet_running && panel_show_output) panelrec = &paneloutput;
#endif
            parm = data->u.list.data+8;
        }
        else
        {
            rec = NULL;
            parm = NULL;
        }

        if (rec != NULL)
        {
            sscanf(parm, "%lu %lu", &bytes, &packets);
            if (rec->last > 0)
            {
                bgone = (gint) (bytes - rec->last) / timegone;
                draw_netload(rec, bgone);
#ifdef HAVE_GNOME_PANEL
                if (panelrec != NULL) draw_netload(panelrec, bgone);
#endif
		/* After 100k, print kilobytes, after 100M, print megabytes */
		if (bytes < 1024*100)
		{
		    sizestr = "";
		    printsize = bytes;
		}
		else if (bytes < 1024*1024*100)
		{
		    sizestr = _("kilo");
		    printsize = bytes/1024;
		}
		else
		{
		    sizestr = _("mega");
		    printsize = bytes/1024/1024;
		}

		str = g_strdup_printf(_("%lu %sbytes %s (%0.2fkB/sec)"),
				 printsize, sizestr,
				 rec == &input ? _("received") : _("sent"),
				 bgone/1024.0);
		gtk_label_set(GTK_LABEL(rec->label), str);
		g_free(str);
	    }
            rec->last = bytes;
        }
    }
}

void netload_init(void)
{
    maxcps = -1;
    memset(&input, 0, sizeof(input));
    memset(&output, 0, sizeof(input));
    memset(&panelinput, 0, sizeof(input));
    memset(&paneloutput, 0, sizeof(input));
}
