#ifndef DAEMON_NETWORK_H
#define DAEMON_NETWORK_H

#include "global.h"

#define TIMED_OUT		0
#define GOT_INPUT		1
#define ALL_COMPLETE	2
#define INPUT_ERROR		3
#define STARTED_DONE	4

#define SIZE_ERROR		-3
#define SIZE_NO_FILE	-2
#define SIZE_UNKNOWN	-1

BOOL StartTransferringFile(FileInfo *file);

void StartMassiveDownload(FileInfo *file);

void DisconnectFile(FileInfo *file, BOOL quick);
void CancelStartGettingFile(FileInfo *file);
int WaitForInput(int timeout);

BOOL CheckFileSpeed(FileInfo *file);
int CheckReadSockets(void);
void CheckWriteSockets(void);
int ReadUploadData(FileInfo *file);

#endif
