/*  $RCSfile: lycos_search.c,v $
 *
 *  $Description: Search interface to the perl code for searching
 *                in lycos. $
 * 
 *  $Library: search $
 *
 *  $Revision: 1.2 $
 *
 *  $Author: sandy $
 *
 *  $Log: lycos_search.c,v $
 *  Revision 1.2  1999/02/13 04:47:54  sandy
 *  Added the GNU license to all files and cleaned up the headers.
 *
 *
 *-------------------------------------------------------------------
 * Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
static char* RCSID="$Id: lycos_search.c,v 1.2 1999/02/13 04:47:54 sandy Exp $";

#include <stdio.h>
#include <EXTERN.h>
#include <perl.h>

#include "lycos.pl.h"

static int
run( char* f, int c, char* arr[] ) 
{
	dSP;
	I32	ax;
	int	count, i;
	SV	*svp;
	ENTER;
	SAVETMPS;
	PUSHMARK(sp);
	XPUSHs(sv_2mortal(newSVpv(f,0)));
	XPUSHs(sv_2mortal(newSViv(c)));
	PUTBACK;
	/* It returns an array or could even die. */
	count = perl_call_pv("search", G_ARRAY | G_EVAL);
	SPAGAIN;
	/* See if we are dead. */
	svp = GvSV(gv_fetchpv("@", TRUE, SVt_PV));
	if( SvTRUE(svp) ) {
		fprintf( stderr, "Error: %s\n", SvPV(svp, na) );
		c = -1;
		POPs;
	} else {
		/* Load the return array from perl in the stack, which
         * should have pointers to strings in it onto the "arr"
         */
		/* Make sure we are not loading more than we have space for. */
		c = ( count < c )? count : c;
		for( i = 0; i < c; i++ ) {
			arr[i] = strdup( POPp );
		}
	}
	PUTBACK;
	FREETMPS;
	LEAVE;

	return c;
}

int doSearch ( char* file, int max_hits, char* hit_list[] )
{
	char *embedding[] = { "", "-e", "0" };
	PerlInterpreter *my_perl;
	int		nhits;

	my_perl = perl_alloc();
	perl_construct( my_perl );

	perl_parse(my_perl, NULL, 3, embedding, NULL);
	perl_run(my_perl);

	/** Treat $a as an integer **/
	perl_eval_pv( script, TRUE );

	nhits = run( file, max_hits, hit_list );

	perl_destruct(my_perl);
	perl_free(my_perl);

	return nhits;
}

#ifdef UNITTEST
int	main (int argc, char** argv, char** env)
{
	int 	nhits = 0;
	char	**hit_list;

	if( argc < 2 ) { 
		fprintf( stderr, "usage: tlycos_search filename [max hits]\n" );
		exit(EXIT_FAILURE);
	}

	if( argc > 2 ) {
	   nhits = atoi( argv[2] );
	}

	if( nhits <= 0 ) nhits = 25;
	
	hit_list = (char**) malloc( sizeof(char*)*nhits );
	if( !hit_list ) {
		fprintf( stderr, "Error allocating memory to store return\n" );
		exit(EXIT_FAILURE);
	}
		
	nhits = doSearch ( argv[1], nhits, hit_list );
	for( ; nhits>0; nhits-- ) {
		printf( "%s\n", hit_list[nhits-1] );
	}
}
#endif
