#ifndef COMMANDS_H
#define COMMANDS_H

void OpenUrl(const char *url, const char *user, const char *password);
void GetFile(const char *path, BOOL directory, BOOL paused, BOOL overwrite);
void PutFile(const char *path, BOOL directory, BOOL paused, BOOL overwrite);
void CloseHost(void);
void RemoteCwd(const char *path);
int LocalCwd(const char *path);
void RemoteDelete(void);
void LocalDelete(void);
void RemotePwd(void);
void RemoteLs(void);
void LocalLs(void);
void RemoteMkDir(const char *name);
void LocalMkDir(const char *name);
void RemoteRename(const char *old, const char *new);
void LocalRename(const char *old, const char *new);

void StartOperation(void);
void StopOperation(void);

#endif
