#!/usr/bin/perl -w
# Address-book editor for Darxite
# Written in GTK+-Perl - which is very, very nice indeed

use Gtk;

$Version = 0.1;
$HomeDir = $ENV{'HOME'};
$ServersFile = "$HomeDir/.darxite/servers";

sub list_clicked {
  #print "The list $_[0] was clicked, row $_[1], col $_[2]\n";
  my $row = $_[1];
  $CurrentRow = $row;
  if ($row < 0 || $row >= $ServerCount) {
    return;
  }
  $HostEntry->set_text($Host[$row]);
  $PathEntry->set_text($Path[$row]);
  $LoginEntry->set_text($LogIn[$row]);
  $PasswordEntry->set_text($Password[$row]);
  $AliasEntry->set_text($Alias[$row]);
  $CommentEntry->set_text($Comment[$row]);
}

sub new_server {
  $ServerList->append("*new*");
  $ServerList->set_row_data($ServerCount, $ServerCount);
  $Host[$ServerCount] = "*new*";
  $Path[$ServerCount] = "";
  $LogIn[$ServerCount] = "";
  $Password[$ServerCount] = "";
  $Alias[$ServerCount] = "";
  $Comment[$ServerCount] = "";
  $ServerCount++;
  $ServerList->select_row($ServerCount - 1, 0);
}

sub delete_server {
  if ($CurrentRow < 0 || $CurrentRow >= $ServerCount) {
    return;
  }
  for ($i = $CurrentRow; $i < $ServerCount; $i++) {
    $Host[$i] = $Host[$i + 1];
    $Path[$i] = $Path[$i + 1];
    $LogIn[$i] = $LogIn[$i + 1];
    $Password[$i] = $Password[$i + 1];
    $Alias[$i] = $Alias[$i + 1];
    $Comment[$i] = $Comment[$i + 1];
  }
  $ServerList->remove($CurrentRow);
  $ServerCount--;
  $ServerList->select_row(0, 0);
}

sub save_servers {
  open FILE, ">$HomeDir/.darxite/servers.perl";
  select FILE;
  print "# Darxite servers file: contains a list of visited servers\n";
  print "# File created automagically by dxaddr.pl version $Version\n\n";
  for ($i = 0; $i < $ServerCount; $i++) {
    my @field;
    $field[0] = $Host[$i];
    $field[1] = $Path[$i];
    $field[2] = $LogIn[$i];
    $field[3] = $Password[$i];
    $field[4] = $Alias[$i];
    $field[5] = $Comment[$i];
    # if the path isn't empty
    if ($field[1] ne "") {
      if (substr($field[1], 0, 1) ne "/") {
        $field[1] = "/" . $field[1];
      }
      if (substr($field[1], length($field[1]) - 1) eq "/") {
        chop $field[1];
      }
    }
    # if the host or path has a space in it
    if (($field[0] =~ / /) || ($field[1] =~ / /)) {
      $field[0] = "\"" . $field[0];
      $field[1] .= "\"";
    }
    # if any of the other fields have spaces in them
    for ($j = 2; $j < 6; $j++) {
      if ($field[$j] =~ / /) {
        $field[$j] = "\"" . $field[$j] . "\"";
      }
      if ($field[$j] ne "") {
        $field[$j] = " " . $field[$j];
      }
    }
    print "$field[0]$field[1] |$field[2] |$field[3] |$field[4] | \\\n";
    print "   $field[5] | |\n";
  }
  close;
}

sub create_window {
   $Window = new Gtk::Window -toplevel;
   $Window->signal_connect("destroy" => sub {Gtk->main_quit});
   $Window->set_usize(400, 400);
   $Window->border_width(10);
   $Window->set_title("Darxite Address Book");

   $MainBox = new Gtk::VBox(0, 5);
   $Window->add($MainBox);
   $MainPanel = new Gtk::HPaned;
   $MainBox->pack_start($MainPanel, 1, 1, 0);
   $LeftBox = new Gtk::VBox(0, 0);
   $MainPanel->add1($LeftBox);
   $Table = new Gtk::Table(6, 2, 0);
   $MainPanel->add2($Table);

   $ServerList = new Gtk::CList(1);
   $ServerList->signal_connect("select_row" => \&list_clicked);
   $ServerList->set_column_title(0, "Servers");
   $ServerList->column_titles_show;
   $LeftBox->pack_start($ServerList, 1, 1, 0);

   $HostLabel = new Gtk::Label("Host:");
   $Table->attach_defaults($HostLabel, 0, 1, 0, 1);
   $HostEntry = new Gtk::Entry;
   $HostEntry->signal_connect("changed" => sub {$Host[$CurrentRow] =
                                              $HostEntry->get_text});
   $Table->attach_defaults($HostEntry, 1, 2, 0, 1);
   
   $PathLabel = new Gtk::Label("Path:");
   $Table->attach_defaults($PathLabel, 0, 1, 1, 2);
   $PathEntry = new Gtk::Entry;
   $PathEntry->signal_connect("changed" => sub {$Path[$CurrentRow] =
                                                  $PathEntry->get_text});
   $Table->attach_defaults($PathEntry, 1, 2, 1, 2);
  
   $LoginLabel = new Gtk::Label("Login:");
   $Table->attach_defaults($LoginLabel, 0, 1, 2, 3);
   $LoginEntry = new Gtk::Entry;
   $LoginEntry->signal_connect("changed" => sub {$LogIn[$CurrentRow] =
                                                   $LoginEntry->get_text});
   $Table->attach_defaults($LoginEntry, 1, 2, 2, 3);
  
   $PasswordLabel = new Gtk::Label("Password:");
   $Table->attach_defaults($PasswordLabel, 0, 1, 3, 4);
   $PasswordEntry = new Gtk::Entry;
   $PasswordEntry->signal_connect("changed" => sub {$Password[$CurrentRow] =
                                              $PasswordEntry->get_text});
   $Table->attach_defaults($PasswordEntry, 1, 2, 3, 4);
  
   $AliasLabel = new Gtk::Label("Alias:");
   $Table->attach_defaults($AliasLabel, 0, 1, 4, 5);
   $AliasEntry = new Gtk::Entry;
   $Table->attach_defaults($AliasEntry, 1, 2, 4, 5);
  
   $CommentLabel = new Gtk::Label("Comment:");
   $Table->attach_defaults($CommentLabel, 0, 1, 5, 6);
   $CommentEntry = new Gtk::Entry;
   $Table->attach_defaults($CommentEntry, 1, 2, 5, 6);

   $ButtonBox = new Gtk::HBox(1, 5);
   $MainBox->pack_start($ButtonBox, 0, 0, 0);
   $NewButton = new Gtk::Button("New");
   $NewButton->signal_connect("clicked" => \&new_server);
   $ButtonBox->pack_start($NewButton, 1, 1, 0);
   $DeleteButton = new Gtk::Button("Delete");
   $DeleteButton->signal_connect("clicked" => \&delete_server);
   $ButtonBox->pack_start($DeleteButton, 1, 1, 0);
   $SaveButton = new Gtk::Button("Save");
   $SaveButton->signal_connect("clicked" => \&save_servers);
   $ButtonBox->pack_start($SaveButton, 1, 1, 0);
   $ExitButton = new Gtk::Button("Exit");
   $ExitButton->signal_connect("clicked" => sub {Gtk->main_quit});   
   $ButtonBox->pack_start($ExitButton, 1, 1, 0);

   $Window->show_all;
 }

sub read_servers {
  $ServerCount = 0;
  open(FILE, $ServersFile);
  while (<FILE>) {
    chomp;
    # skip comments
    if (/^\#/) {
      next;
    }
    $line = $_;
    # squidge multiple lines into one
    while (/\\$/) {
      $_ = <FILE>;
      chomp;
      $line = $line.$_;
    }
    $line =~ s/\\//g;
    if ($line eq "") {next;}
    @fields = split (/\|/,$line);
    # get rid of the whitespace
    foreach $field (@fields) {
      while (substr($field, 0, 1) eq " ") {
        $field = substr($field, 1);
      }
      while (substr($field, 0, 1) eq "\"") {
        $field = substr($field, 1);
      }
      while (substr($field, length($field) - 1) eq " ") {
        chop $field;
      }
      while (substr($field, length($field) - 1) eq "\"") {
        chop $field;
      }
    }
    $path = "";
    ($server, $path) = split /\//, $fields[0], 2;
    if (!$path) {
      $path = "";
    }
    $ServerList->append($server);
    $ServerList->set_row_data($ServerCount, $ServerCount);
    $Host[$ServerCount] = $server;
    $Path[$ServerCount] = $path;
    $LogIn[$ServerCount] = $fields[1];
    $Password[$ServerCount] = $fields[2];
    $Alias[$ServerCount] = $fields[3];
    $Comment[$ServerCount] = $fields[4];
    $ServerCount++;
  }
  $CurrentRow = 0;
  $ServerList->select_row(0, 0);
  close FILE;
}

Gtk->init;
create_window;
read_servers;
Gtk->main;
