/* Gnome Darxite Control
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 *
 * control-page.h
 * written by Manuel Clos <mclos000@correu.udg.es>
 * based upon gtop-page by Martin Baulig <martin@home-of-linux.org>
 * based upon hex-document.h from Jaka Mocnik <jaka.mocnik@kiss.uni-lj.si>
 */

#define CONTROL_PAGE(obj)          GTK_CHECK_CAST (obj, control_page_get_type (), ControlPage)
#define CONTROL_PAGE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, control_page_get_type (), ControlPageClass)
#define IS_CONTROL_PAGE(obj)       GTK_CHECK_TYPE (obj, control_page_get_type ())

typedef struct _ControlPage        ControlPage;
typedef struct _ControlPageClass   ControlPageClass;
typedef enum _ControlPageType      ControlPageType;

enum _ControlPageType
{
        CONTROL_PAGE_BATCH = 0,
        CONTROL_PAGE_FILELOG
};

struct _ControlPage
{
        GnomeMDIChild mdi_child;

        ControlPageType type;

	GtkWidget *main_widget;
	
	GSList	*items;
};

struct _ControlPageClass
{
        GnomeMDIChildClass parent_class;
};

ControlPage *control_page_new (ControlPageType type);
GnomeMDIChild *control_page_create_from_config (const gchar *);
void remove_child_cb(GtkWidget *w);

guint control_page_get_type (void);

/*Miscellaneous callbacks*/
void play_cb(void);
void pause_cb(void);
void cancel_cb(void);
void reget_cb(void);
void clear_list_cb(void);
void clear_log_cb(void);

void free_FileInfo(FileInfo *fi);

gchar *bytes_to_string(gint value);
gchar *bytesXs_to_string(gint value);
gchar *seconds_to_string(gint value);

void put_color(GtkWidget *clist, gint row, gint type);
