/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include <gnome.h>

#include "daemon.h"
#include "dnd.h"
#include "prefs-dnd.h"
#include "callbacks.h"

GtkWidget *cb_show_dialog;
GtkWidget *cb_cumulative;
GtkWidget *cb_clipboard;
GtkWidget *cb_never_paused;
GtkWidget *cb_resume;
GtkWidget *cb_outputdir;
GtkWidget *cb_default_flags;
GtkWidget *b_change_defaults;

static void properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox);
GtkWidget * dnd_tab_make(GnomePropertyBox *pbox);
void dnd_tab_apply_changes();
void dnd_tab_load_config();
void dnd_tab_save_config();

//--------------------------------------------------------------

static void
properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox)
{
        gnome_property_box_changed(pbox);
}

GtkWidget *
dnd_tab_make(GnomePropertyBox *pbox)
{
	GtkWidget *vbox_main;
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *frame;
	GtkWidget *hbox;

	vbox_main = gtk_vbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_main), GNOME_PAD_SMALL);
        gtk_widget_show(vbox_main);

	frame = gtk_frame_new(_("Behaviour"));
        gtk_box_pack_start(GTK_BOX(vbox_main), frame, TRUE, TRUE, 0);
        gtk_widget_show(frame);

        vbox = gtk_vbox_new(FALSE, GNOME_PAD);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
        gtk_container_border_width(GTK_CONTAINER(vbox), GNOME_PAD_SMALL);
        gtk_widget_show(vbox);

	/*Behaviour*/
	cb_show_dialog = gtk_check_button_new_with_label(
           	_("Show dialog when drop received (interactive)"));
        gtk_box_pack_start(GTK_BOX(vbox), cb_show_dialog, FALSE, TRUE, 0);
        gtk_widget_show(cb_show_dialog);

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);  
        gtk_widget_show(hbox);

	frame = gtk_frame_new(_("Interactive"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);
        gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, GNOME_PAD);
	gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

        cb_cumulative = gtk_check_button_new_with_label(
           	_("Use Accumulative Drops"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_cumulative, TRUE, FALSE, 0);
/*FIXME: Cumulative is not coded yet!!!
        gtk_widget_show(cb_cumulative);*/

        cb_clipboard = gtk_check_button_new_with_label(
           	_("Always Paste from clipboard"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_clipboard, TRUE, FALSE, 0);
	gtk_widget_show(cb_clipboard);

	frame = gtk_frame_new("Non Interactive");
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);
        gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, GNOME_PAD);
	gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

	cb_never_paused = gtk_check_button_new_with_label(
           	_("Never Paused"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_never_paused, TRUE, FALSE, 0);
        gtk_widget_show(cb_never_paused);

	cb_resume = gtk_check_button_new_with_label(
           	_("Always Resume files (do not ask)"));
        gtk_box_pack_start_defaults(GTK_BOX(vbox), cb_resume);
        gtk_widget_show(cb_resume);

        cb_outputdir = gtk_check_button_new_with_label(
           	_("Use Default Output Directory"));
        gtk_box_pack_start(GTK_BOX(vbox), cb_outputdir, TRUE, FALSE, 0);
        gtk_widget_show(cb_outputdir);

        cb_default_flags = gtk_check_button_new_with_label(
           	_("Use Default Flags"));
        gtk_box_pack_start(GTK_BOX(vbox), cb_default_flags, TRUE, FALSE, 0);
        gtk_widget_show(cb_default_flags);

	b_change_defaults = gnome_pixmap_button(gnome_stock_new_with_icon
			(GNOME_STOCK_PIXMAP_PREFERENCES), _("Change Defaults"));
        gtk_box_pack_start(GTK_BOX(vbox), b_change_defaults, TRUE, FALSE, 0);
        gtk_widget_show(b_change_defaults);
        gtk_signal_connect(GTK_OBJECT(b_change_defaults), "clicked",
				GTK_SIGNAL_FUNC (control_centre_cb), NULL);

//Set preferences:

        if (show_dialog)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_show_dialog), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_show_dialog), "clicked",
					properties_modified_cb, pbox);


        if (use_cumulative)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_cumulative), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_cumulative), "clicked",
					properties_modified_cb, pbox);

        if (use_clipboard)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_clipboard), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_clipboard), "clicked",
					properties_modified_cb, pbox);

        if (not_paused)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_never_paused), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_never_paused), "clicked",
					properties_modified_cb, pbox);

        if (use_resume)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_resume), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_resume), "clicked",
					properties_modified_cb, pbox);

        if (use_outputdir)
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_outputdir), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_outputdir), "clicked",
					properties_modified_cb, pbox);

        if (use_flags)
           gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_default_flags), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_default_flags), "clicked",
					properties_modified_cb, pbox);

	return vbox_main;
}

void dnd_tab_apply_changes()
{
	if (GTK_TOGGLE_BUTTON(cb_show_dialog)->active)
	   show_dialog = TRUE;
	else
	   show_dialog = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_clipboard)->active)
	   use_clipboard = TRUE;
	else
	   use_clipboard = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_never_paused)->active)
	   not_paused = TRUE;
	else
	   not_paused = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_resume)->active)
	   use_resume = TRUE;
	else
	   use_resume = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_resume)->active)
	   use_resume = TRUE;
	else
	   use_resume = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_outputdir)->active)
	   use_outputdir = TRUE;
	else
	   use_outputdir = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_default_flags)->active)
	   use_flags = TRUE;
	else
	   use_flags = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_cumulative)->active)
	   use_cumulative = TRUE;
	else
	   use_cumulative = FALSE;
}

void dnd_tab_load_config()
{
	DND = g_malloc(sizeof(DndWindow));
	DND->window = NULL;

	DND->x = gnome_config_get_int("dnd/x=0");
	DND->y = gnome_config_get_int("dnd/y=0");	
	DND->width = gnome_config_get_int("dnd/width=400");	
	DND->height = gnome_config_get_int("dnd/height=430");	
	DND->Dtab_position = gnome_config_get_int("dnd/Dtab_position=150");

	show_dialog = gnome_config_get_int("dnd/show_dialog=1");
	use_clipboard = gnome_config_get_int("dnd/use_clipboard=0");
	not_paused = gnome_config_get_int("dnd/not_paused=1");
	use_resume = gnome_config_get_int("dnd/use_resume=0");
	use_outputdir = gnome_config_get_int("dnd/use_outputdir=1");
	use_flags = gnome_config_get_int("dnd/use_flags=1");
	use_cumulative = gnome_config_get_int("dnd/use_cumulative=1");
}

void dnd_tab_save_config()
{
	if (DND->window)
	{
	gdk_window_get_size((GdkWindow *)(DND->window)->window,
			&DND->width, &DND->height);
	gnome_config_set_int("dnd/x", DND->x);
	gnome_config_set_int("dnd/y", DND->y);
	gnome_config_set_int("dnd/width", DND->width);
	gnome_config_set_int("dnd/height", DND->height);

	DND->Dtab_position = GTK_PANED(DND->Dtab_paned)->child1_size;
	gnome_config_set_int("dnd/Dtab_position", DND->Dtab_position);
	}

        gnome_config_set_int("dnd/show_dialog", show_dialog);
        gnome_config_set_int("dnd/use_clipboard", use_clipboard);
        gnome_config_set_int("dnd/not_paused", not_paused);
        gnome_config_set_int("dnd/use_resume", use_resume);
        gnome_config_set_int("dnd/use_outputdir", use_outputdir);
        gnome_config_set_int("dnd/use_flags", use_flags);
        gnome_config_set_int("dnd/use_cumulative", use_cumulative);
}






