/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include <darxite.h>

gchar *darxite_client;

//State of the client
gboolean connected;

//Some config options
gboolean startup_connect;
gboolean startup_local; //TRUE=local FALSE=remote

gboolean retry_connect_local;
gint retry_timeout_local;
gboolean retry_connect_remote;
gint retry_timeout_remote;
gboolean file_count_local;
gint file_count_timeout_local;
gboolean file_count_remote;
gint file_count_timeout_remote;
gboolean file_status_local;
gint file_status_timeout_local;
gboolean file_status_remote;
gint file_status_timeout_remote;
gboolean auto_start_local;
gboolean always_connected_local;

gboolean local;

gint fd;

gchar *host;
gint  port;
gchar *password;

#define SIGPIPE 13

//Every client needs this:
void get_data (gpointer data, gint source, GdkInputCondition condition);
gint input_response; /* For the gdk_input_add function */
void configure_connection(); //Send the proper configuration commands
void configure_disconnection(); //Mainly app post-disconnection stuff
gint retry_connect_cb(gpointer data);
gint file_count_cb(gpointer data);
gint file_status_cb(gpointer data);

gint retry_connect_timeout;
gint file_count_timeout;
gint file_status_timeout;

gboolean first_file_status_sent;

//Main implemented
void SendToDaemon(gchar *command);

