/* Gnome Darxite common code
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

/*Includes*/
#include <gnome.h>

#include "daemon.h"
#include "connect.h"
#include "callbacks.h"

void remote_dialog_ok();

GtkWidget *host_entry;
GtkWidget *port_entry;
GtkWidget *password_entry;

void remote_dialog(GtkWindow *main_window)
{
	GtkWidget *dialog;
	GtkWidget *vbox;
	GtkWidget *alignment;
	GtkWidget *host_label;
	GtkWidget *port_label;
	GtkWidget *password_label;
	
	dialog = gnome_dialog_new(
		"Remote connection",
		GNOME_STOCK_BUTTON_OK,
		GNOME_STOCK_BUTTON_CANCEL,
		NULL);

	gnome_dialog_set_close(GNOME_DIALOG(dialog), FALSE);
	gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);

	if (main_window)
	   gnome_dialog_set_parent (GNOME_DIALOG (dialog), main_window);
			
	gnome_dialog_button_connect(GNOME_DIALOG(dialog), 0,
							remote_dialog_ok,
							dialog);
	gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 1,
							gtk_widget_destroy,
							GTK_OBJECT (dialog));

	vbox = gtk_vbox_new(FALSE, FALSE);
        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox),
        				vbox, TRUE, FALSE, 0);
        gtk_widget_show(vbox);

   	alignment = gtk_alignment_new(0,0,0,0);
        gtk_box_pack_start(GTK_BOX(vbox), alignment, TRUE, FALSE, 0);
        gtk_widget_show(alignment);
                        
	host_label = gtk_label_new(_("Host:"));
	gtk_container_add(GTK_CONTAINER(alignment), host_label);
	gtk_widget_show(host_label);

	host_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(vbox),
        				host_entry, TRUE, FALSE, 0);
	gtk_widget_show(host_entry);
	gtk_widget_grab_focus(host_entry);
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog),
				GTK_EDITABLE(host_entry));

	gtk_entry_set_text(GTK_ENTRY(host_entry), host);

	vbox = gtk_vbox_new(FALSE, FALSE);
        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox),
        				vbox, TRUE, FALSE, 0);
        gtk_widget_show(vbox);

   	alignment = gtk_alignment_new(0,0,0,0);
        gtk_box_pack_start(GTK_BOX(vbox), alignment, TRUE, FALSE, 0);
        gtk_widget_show(alignment);

	port_label = gtk_label_new(_("Port:"));
	gtk_container_add(GTK_CONTAINER(alignment), port_label);
	gtk_widget_show(port_label);

	port_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(vbox),
        				port_entry, TRUE, FALSE, 0);
	gtk_widget_show(port_entry);
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog),
				GTK_EDITABLE(port_entry));

	gtk_entry_set_text(GTK_ENTRY(port_entry), g_strdup_printf("%i", port));

	vbox = gtk_vbox_new(FALSE, FALSE);
        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox),
        				vbox, TRUE, FALSE, 0);
        gtk_widget_show(vbox);

   	alignment = gtk_alignment_new(0,0,0,0);
        gtk_box_pack_start(GTK_BOX(vbox), alignment, TRUE, FALSE, 0);
        gtk_widget_show(alignment);

	password_label = gtk_label_new(_("Password:"));
	gtk_container_add(GTK_CONTAINER(alignment), password_label);
	gtk_widget_show(password_label);

	password_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(vbox),
        				password_entry, TRUE, FALSE, 0);
	gtk_widget_show(password_entry);
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog),
				GTK_EDITABLE(password_entry));
	gtk_entry_set_visibility(GTK_ENTRY(password_entry), FALSE);
	gtk_entry_set_text(GTK_ENTRY(password_entry), password);

	gtk_widget_show(dialog);
}

void remote_dialog_ok(GtkWidget *widget, gpointer data)
{
	gchar *new_host;
	gint  new_port = -1;
	gchar *new_password;

	new_host = gtk_entry_get_text(GTK_ENTRY(host_entry));
	sscanf(gtk_entry_get_text(GTK_ENTRY(port_entry)), "%u", &new_port);
	new_password = gtk_entry_get_text(GTK_ENTRY(password_entry));

	g_print("Trying to connect to %s at port %i with password \"%s\"\n",
		new_host, new_port, new_password);

	if (remote_connection(new_host, new_port, new_password))
	{
	   g_print("Failed to connect to %s at port %i with password \"%s\"\n",
	   		new_host, new_port, new_password);
	   g_print("DX_errno = %i\n", DX_errno);
	}
	else	
	   gtk_widget_destroy(data); // data is the dialog widget.	
}

gint remote_connection(gchar *new_host, gint new_port,
		gchar *new_password) //returns 0 on success 1 otherwhise
{
	gint new_fd;

	new_fd = DX_ConnectRemoteClient(new_host,
				new_port, new_password, darxite_client);
	if (new_fd < 0)
	{
	   //Connection failed :(
	   return 1;
	}
	else
	{
	   //Connection ok :)
	   if (connected)
	      DisconnectClient();
	   fd = new_fd;
	   connected = 1;
	   local = 0;
	   host = g_strdup(new_host);
	   port = new_port;
	   password = g_strdup(new_password);
	   configure_connection();

//FIXME: Test version!.
	}

	return 0;
}

gint local_connection() //returns 0 on success 1 otherwhise
{
	gint new_fd;

	new_fd = DX_ConnectClient(darxite_client);
	if (new_fd < 0)
	{
	   //Connection failed :(
	   return 1;
	}
	else
	{
	   //Connection ok :)
	   if (connected)
	      DisconnectClient();
	   fd = new_fd;
	   connected = 1;
	   local = 1;
	   configure_connection();

//FIXME: Test version!.
	}

	return 0;
}

void DisconnectClient()
{
	if (connected)
	{
#ifdef DEBUG_MESSAGES
	   g_print("Disconnecting client %s with fd = %i\n",
	   		 darxite_client, fd);
#endif
	   if (input_response > 0)
	      gdk_input_remove(input_response);
	   DX_DisconnectClient(fd);
	   connected = 0;
	   configure_disconnection();
	}
	if (always_connected_local)
	   local_connection_cb();
}

void local_connection_cb()
{
	//connect to local daemon!
	local = TRUE;
	if (local_connection())
	   if (auto_start_local)
	   {
	      //Autostart the local daemon
	      if(do_autostart_daemon())
	      {
	         //try to connect again if there are no errors.
	         if(local_connection())
	         {
	            //and start to retry if we are set to...
	            if (retry_connect_local)
	               retry_connect_timeout = gtk_timeout_add
	        		  (retry_timeout_local*1000, retry_connect_cb, NULL);
	         }
	      }
	   }
/*FIXME: this lines were commented...*/
	if (!connected && retry_connect_local)
	   retry_connect_timeout = gtk_timeout_add
	        		(retry_timeout_local*1000, retry_connect_cb, NULL);
}

void
start_stop_daemon_cb(void)
{
	if (connected)
	{
//	   b = g_strconcat(DX_BinPath(), "/darxite -k", NULL);
	   SendToDaemon("Kill\n");
	}
	else
	{
	   //Try to connect
	   if (local_connection())
	   {
	      //If not connected, do_autostart_daemon
	      //this means, del the socket if present,
	      //and start the daemon.
	      if(do_autostart_daemon())
	      {
	         //try to connect again if there are no errors.
	         if(local_connection())
	         {
	            //and start to retry if we are set to...
	            if (retry_connect_local)
	               retry_connect_timeout = gtk_timeout_add
	        		  (retry_timeout_local*1000, retry_connect_cb, NULL);
	         }
	      }
	   }
	}
}

/* Return 1 if we successfully autostarted.  Return
 * 0 if we tried to autostart and failed.
 * I have modified this Glenn's function when reworking
 * the whole thing, thanks Glenn ;).
 */

gint
do_autostart_daemon(void)
{
	gchar *buffer;

	buffer = g_strconcat("/tmp/darxsock.", getpwuid(getuid())->pw_name, NULL);

	if (access(buffer, R_OK) != -1) 
	{
	   if (remove(buffer) == -1)
	      show_warning("Error deleting darxite socket.");
	}
	free(buffer);

	buffer = g_strconcat(DX_BinPath(), "/darxite", NULL);
	if (system(buffer) != 0)
	{
	   free(buffer);
	   g_print("Error executing darxite daemon!\n");
	   return 0;
	}

	return 1;
}
