
/*********************************************************************
 *                
 * Filename:      thinkpad_common.h
 * Description:   common stuff for the "thinkpad" modules
 * Status:        beta
 * Author:        Thomas Hood <jdthood@mail.com>
 * Created:       19 July 1999 
 *
 * Please report bugs to the author ASAP.
 * 
 *     Copyright (c) 1999 J.D. Thomas Hood, All rights reserved
 *     
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 * 
 *     To receive a copy of the GNU General Public License, please write
 *     to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *     Boston, MA 02111-1307 USA
 *     
 ********************************************************************/

#if !defined(__THINKPAD_COMMON_H__)
#define __THINKPAD_COMMON_H__

/* All module (etc.) names should be no longer than this: */
#define LEN_NAME_MAX 80

/* All version strings should be no longer than this: */
#define LEN_VERSION_MAX 20

/****** macros ******/

#ifdef DEBUG_IOPARM
#define DEBUG_PRINT_OUTPARMS( ioparmThe ) { \
	printf( "bRc:      0x%x\n", ioparmThe.out.bRc ); \
	printf( "bSubRc:   0x%x\n", ioparmThe.out.bSubRc ); \
	printf( "wParm1:   0x%x\n", ioparmThe.out.wParm1 ); \
	printf( "wParm2:   0x%x\n", ioparmThe.out.wParm2 ); \
	printf( "wParm3:   0x%x\n", ioparmThe.out.wParm3 ); \
	printf( "dwParm4:  0x%lx\n", (unsigned long) ioparmThe.out.dwParm4 ); \
	printf( "dwParm5:  0x%lx\n", (unsigned long) ioparmThe.out.dwParm5 ); \
}
#define DEBUG_PRINT_INPARMS( ioparmThe ) { \
	printf( "bFunc:    0x%x\n", ioparmThe.in.bFunc ); \
	printf( "bSubFunc: 0x%x\n", ioparmThe.in.bSubFunc ); \
	printf( "wParm1:   0x%x\n", ioparmThe.in.wParm1 ); \
	printf( "wParm2:   0x%x\n", ioparmThe.in.wParm2 ); \
	printf( "wParm3:   0x%x\n", ioparmThe.in.wParm3 ); \
	printf( "dwParm4:  0x%lx\n", (unsigned long) ioparmThe.in.dwParm4 ); \
	printf( "dwParm5:  0x%lx\n", (unsigned long) ioparmThe.in.dwParm5 ); \
}
#else
#define DEBUG_PRINT_OUTPARMS( ioparmThe )
#define DEBUG_PRINT_INPARMS( ioparmThe )
#endif


/****** types ******/

typedef __u8 byte;
typedef __u16 word;
typedef __u32 dword;
typedef char flag_t;
typedef byte bcd8_t;


/****** return values ******/

/* 0 as a return value always means OK */

/*
 * ioctl() returns 0 for success, or a negative number for an error
 * and sets global variable "errno" to the error number.
 *
 * Our convention is to return such errnos as negative numbers.
 */

/*
 * We use the following standard UNIX errno's, defined in <asm/errno.h>
 * EFAULT       memory error
 * EBUSY        device is already open
 * EINVAL       function code not recognized
 * ENOTTY       ioctl code not recognized
 * EACCESS      inadequate permission to perform action
 *
 * We use the following standard errno's under
 * names more descriptive for our purposes
 */
#define ETHINKPAD_EXECUTION        EIO
#define ETHINKPAD_PROGRAMMING      ENOSYS
#define ETHINKPAD_HW_NOT_FOUND     ENXIO
#define ETHINKPAD_MODULE_DISABLED  ESPIPE
#define ETHINKPAD_MODULE_NOT_FOUND ENODEV
#define ESMAPI_SMB                 EPIPE

/*** other return values ***/
/*
 * smapi bios error codes are defined in smapibios.h 
 * they fall within the range 1 to 0xFF .  We should
 * not assign any other ERR codes in this range.
 * We pass these as positive integers.
 */

/*
 * smapidev error codes should fall into the range 0x1000 to 0x1FFF
 * We pass these as positive integers.
 */

#endif
