/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

#include "data.h"
#include "erreur.h"


GtkWidget *output_entry;
GtkWidget *report_selector;

int report_disks;
int report_folders;
int report_files;
int report_location;
int report_description;
int report_just_commented;
int sort_by_cat;
int report_category;
int report_just_with_category;


GtkWidget *cat_combobox;
GtkWidget *disk_combo;

void button_checked(GtkWidget *w, gpointer data)
{
  switch((int) data)
    {
    case 0:
      if (report_disks == 0) report_disks = 1;
      else report_disks = 0;
      return;
    case 1:
      if (report_folders == 0) report_folders = 1;
      else report_folders = 0;
      return;
    case 2:
      if (report_files == 0) report_files = 1;
      else report_files = 0;
      return;
    case 3:
      if (report_location == 0) report_location = 1;
      else report_location = 0;
      return;
    case 4:
      if (report_description == 0) report_description = 1;
      else report_description = 0;
      return;
    case 5:
      if (report_just_commented == 0) report_just_commented = 1;
      else report_just_commented = 0;
      return;
    case 6:
      if (sort_by_cat == 0) sort_by_cat = 1;
      else sort_by_cat = 0;
      return;	
    case 7:
      if (report_category == 0) report_category = 1;
      else report_category = 0;
      return;	
    case 8:
      if (report_just_with_category == 0) report_just_with_category = 1;
      else report_just_with_category = 0;
      return;	
    }
}


void report_for_cat(Folder* folder, FILE *file,char *path,int cat)
{
  int i,k;
  char *temp_path;

  for(i=0;i<folder->nb_files;i++)
    {
      if (report_files == 1)
	{
	  if(((folder->files[i].categorie == cat)||(cat == -1))&&((report_just_commented == 0)||((report_just_commented == 1)&&(folder->files[i].description != 0))))
	    {
	      fprintf(file,"         %s",folder->files[i].name);
	  if ((report_description == 1)&&(folder->files[i].description != 0)) fprintf(file," : %s",descriptions[folder->files[i].description]);
	  fprintf(file,"\n");
	    }
	}
    }
  for(i=0;i<folder->nb_folders;i++)
    {
      if(report_folders == 1)
	{
	  if(((folder->folders[i].categorie == cat)||(cat == -1))&&((report_just_commented == 0)||((report_just_commented == 1)&&(folder->folders[i].description != 0))))
	    {
	      fprintf(file,"      %s",folder->folders[i].name);
	      if ((report_description == 1)&&(folder->folders[i].description != 0)) fprintf(file," : %s",descriptions[folder->folders[i].description]);
	      if (report_location == 1) fprintf(file," (%s)",path);
	      fprintf(file,"\n      ");
	      for(k=0;k<strlen(folder->folders[i].name);k++) fprintf(file,"~"); 
	      fprintf(file,"\n");
	    }
	  temp_path = (char *)malloc((strlen(path)+strlen(folder->folders[i].name)+2)*sizeof(char));
	  sprintf(temp_path,"%s%s/",path,folder->folders[i].name);
	  report_for_cat(&folder->folders[i],file,temp_path,cat);
	  free(temp_path);
	  temp_path = NULL;
	}
    }
}

void generate_cat_report(FILE *file)
{
  int i,j,k,l;
 // char path[] = "";
  char temp_path[1024];
  char *the_cat;
  char *the_disk;
  int cat_to_report;
  int disk_to_report;

  the_cat = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cat_combobox)->entry))); 
  if (strlen(the_cat) == 0) cat_to_report = 0;
  else if(strcmp(the_cat,"All categories") == 0) cat_to_report = -1;
  else
    {
      for(i=1;i<nb_categories;i++)
	{
	  if(strcmp(the_cat,categories[i]) == 0) cat_to_report = i;
	}
    }


  the_disk = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(disk_combo)->entry))); 
  if(strcmp(the_disk,"All disks") == 0) disk_to_report = -1;
  else
    {
      for(i=0;i<racine.nb_folders;i++)
	{
	  if(strcmp(the_disk,racine.folders[i].name) == 0) disk_to_report = i;
	}
    }


  fprintf(file,"Categories exist in archive\n===========================\n");
  for(i=1;i<nb_categories;i++) fprintf(file,"    %s\n",categories[i]);
  fprintf(file,"\n");
  if (cat_to_report == -1)
    {
      for(i=1;i<nb_categories;i++)
	{
	  fprintf(file,"Category: %s\n==========",categories[i]);
	  for(j=0;j<strlen(categories[i]);j++)fprintf(file,"=");
	  fprintf(file,"\n");
	  for(k=0;k<racine.nb_folders;k++)
	    {
	      if((disk_to_report == -1)||(disk_to_report == k))
		{
		  if (((report_disks == 1)&&(racine.folders[k].categorie == i))&&((report_just_commented == 0)||((report_just_commented == 1)&&(racine.folders[k].description != 0))))
		    {
		      fprintf(file,"\n   %s\n   ",racine.folders[k].name);
		      for(l=0;l<strlen(racine.folders[k].name);l++) fprintf(file,"-");
		      fprintf(file,"\n");
		    }
		  sprintf(temp_path,"[%s]/",racine.folders[k].name);
		  report_for_cat(&racine.folders[k],file,temp_path,i);
		}
	    }
	}
     if(report_just_with_category == 0)
       {
	 i = 0;
	 fprintf(file,"Category: None\n==============");
	 fprintf(file,"\n");
	 for(k=0;k<racine.nb_folders;k++)
	   { 
	     if((disk_to_report == -1)||(disk_to_report == k))
	       {
		 if (((report_disks == 1)&&(racine.folders[k].categorie == i))&&((report_just_commented == 0)||((report_just_commented == 1)&&(racine.folders[k].description != 0))))
		   {
		     fprintf(file,"\n   %s\n   ",racine.folders[k].name);
		     for(l=0;l<strlen(racine.folders[k].name);l++) fprintf(file,"-");
		     fprintf(file,"\n");
		   }
		 sprintf(temp_path,"[%s]/",racine.folders[k].name);
		 report_for_cat(&racine.folders[k],file,temp_path,i);
	       }	  
	   }
       }
    }
  else 
    {
      i = cat_to_report;
      if (i != 0)
	{
	  fprintf(file,"Category: %s\n==========",categories[i]);
	  for(j=0;j<strlen(categories[i]);j++)fprintf(file,"=");
	}
      else fprintf(file,"Category: None\n==============");
      fprintf(file,"\n");
      
      for(k=0;k<racine.nb_folders;k++)
	{
	  if (((report_disks == 1)&&(racine.folders[k].categorie == i))&&((report_just_commented == 0)||((report_just_commented == 1)&&(racine.folders[k].description != 0))))
	    {
	      fprintf(file,"\n   %s\n   ",racine.folders[k].name);
	      for(l=0;l<strlen(racine.folders[k].name);l++) fprintf(file,"-");
	      fprintf(file,"\n");
	    }
	  sprintf(temp_path,"[%s]/",racine.folders[k].name);
	  report_for_cat(&racine.folders[k],file,temp_path,cat_to_report);
	} 
    }
}




void report_for_file(Folder* folder, FILE *file,char *path,int cat,int decalage)
{
  int i,j,k;
  char *temp_path;

  //printf("in, report\n");
  for(i=0;i<folder->nb_files;i++)
    {
      if (report_files == 1)
	{
	  if(((folder->files[i].categorie == cat)||(cat == -1))&&((report_just_commented == 0)||((report_just_commented == 1)&&(folder->files[i].description != 0)))&&((((report_just_with_category == 1)&&(folder->files[i].categorie != 0))||(report_just_with_category == 0))))
	    {
	      for(j=0;j<decalage;j++) fprintf(file,"  ");
	      fprintf(file,"%s",folder->files[i].name);
	      if (((report_category == 1)&&(folder->files[i].categorie != 0))||((report_description == 1)&&(folder->files[i].description != 0))) fprintf(file," : ");
	      if ((report_category == 1)&&(folder->files[i].categorie != 0)) fprintf(file,"%s ",categories[folder->files[i].categorie]);
	      if (((report_category == 1)&&(folder->files[i].categorie != 0))||((report_description == 1)&&(folder->files[i].description != 0))) fprintf(file,": ");
	      if ((report_description == 1)&&(folder->files[i].description != 0)) fprintf(file,"%s",descriptions[folder->files[i].description]);
	      fprintf(file,"\n");
	    }
	}
    }
  for(i=0;i<folder->nb_folders;i++)
    {
      if(report_folders == 1)
	{
	  if(((folder->folders[i].categorie == cat)||(cat == -1))&&((report_just_commented == 0)||((report_just_commented == 1)&&(folder->folders[i].description != 0)))&&((((report_just_with_category == 1)&&(folder->folders[i].categorie != 0))||(report_just_with_category == 0))))
	    {
	      for(j=0;j<decalage;j++) fprintf(file,"  ");
	      fprintf(file,"%s",folder->folders[i].name);
	      if (((report_category == 1)&&(folder->folders[i].categorie != 0))||((report_description == 1)&&(folder->folders[i].description != 0)))fprintf(file,": ");
	      if ((report_category == 1)&&(folder->folders[i].categorie != 0)) fprintf(file,"%s ",categories[folder->files[i].categorie]);
	      if (((report_category == 1)&&(folder->folders[i].categorie != 0))||((report_description == 1)&&(folder->folders[i].description != 0))) fprintf(file,": ");
	      if ((report_description == 1)&&(folder->folders[i].description != 0)) fprintf(file,"%s ",descriptions[folder->folders[i].description]);
	      if (report_location == 1) fprintf(file," (%s)",path);
	      fprintf(file,"\n");
	      for(j=0;j<decalage;j++) fprintf(file,"  ");
	      for(k=0;k<strlen(folder->folders[i].name);k++) fprintf(file,"~"); 
	      fprintf(file,"\n");
	    }
	  temp_path = (char *)malloc((strlen(path)+strlen(folder->folders[i].name)+2)*sizeof(char));
	  sprintf(temp_path,"%s%s/",path,folder->folders[i].name);
	  report_for_file(&folder->folders[i],file,temp_path,cat,decalage+1);
	  free(temp_path);
	  temp_path = NULL;
	}
    }
}





void generate_file_report(Folder *folder,FILE *file)
{
  int i,k,l;
  char temp_path[1024];
  char *the_cat;
  char *the_disk;
  int cat_to_report;
  int disk_to_report;

  the_cat = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cat_combobox)->entry))); 
  if (strlen(the_cat) == 0) cat_to_report = 0;
  else if(strcmp(the_cat,"All categories") == 0) cat_to_report = -1;
  else
    {
      for(i=1;i<nb_categories;i++)
	{
	  if(strcmp(the_cat,categories[i]) == 0) cat_to_report = i;
	}
    }
  
  
  the_disk = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(disk_combo)->entry))); 
  if(strcmp(the_disk,"All disks") == 0) disk_to_report = -1;
  else
    {
      for(i=0;i<racine.nb_folders;i++)
	{
	  if(strcmp(the_disk,racine.folders[i].name) == 0) disk_to_report = i;
	}
    }
  
  
  for(k=0;k<racine.nb_folders;k++)
    {
      if((disk_to_report == -1)||(disk_to_report == k))
	{
	  if ((report_disks == 1)&&((cat_to_report == -1)||(racine.folders[k].categorie == cat_to_report))&&((report_just_commented == 0)||((report_just_commented == 1)&&(racine.folders[k].description != 0))))
	    {
	      fprintf(file,"\n%s\n",racine.folders[k].name);
	      for(l=0;l<strlen(racine.folders[k].name);l++) fprintf(file,"-");
	      fprintf(file,"\n");
	    }
	  sprintf(temp_path,"[%s]/",racine.folders[k].name);
	  report_for_file(&racine.folders[k],file,temp_path,cat_to_report,1);
	}
    }
}


void report_generated()
{
  erreur_dialog(output_entry, "Report successful.", "", "Report generated");

}


int begin_report(GtkWidget *w, gpointer data)
{
  char *path;
  FILE *file;

  path = gtk_entry_get_text(GTK_ENTRY (output_entry));
  if ((file = fopen(path,"w+")) == NULL)
    {
      erreur_dialog(w, "Can't create file. Permission", "denied, disk full or bad path.", "ERROR !");
      return(-1);
    }
  fprintf(file,"This report was generated by GTKtalog.\nhttp://www.geocities.com/SiliconValley/Bit/2458/index.html\n\n");
  
  fprintf(file,"The report type is: ");
  if(sort_by_cat == 1)  fprintf(file,"Sort by category.");
  else fprintf(file,"Sort by Disk->folder->file.");
  fprintf(file,"\n===================\n");
  fprintf(file,"  It contain:\n");
  if(report_disks == 1) fprintf(file,"           - disk name.\n");
  if(report_folders == 1) fprintf(file,"           - folder name.\n");
  if(report_files == 1) fprintf(file,"           - file name.\n");
  if(report_location == 1) fprintf(file,"           - folder location.\n");
  if(report_description == 1) fprintf(file,"           - description.\n");
  if(report_category == 1) fprintf(file,"           - category.\n");
  fprintf(file,"\n");
  if(report_just_with_category == 1) fprintf(file,"           - Just items with category.\n");
  if(report_just_commented == 1) fprintf(file,"           - Just items with description.\n");
  fprintf(file,"\n");



  if (sort_by_cat == 1) generate_cat_report(file);
  else generate_file_report(&racine,file);
  
  fclose(file);
  report_generated();
  return(0);
}


void set_report_file (GtkWidget *w, GtkFileSelection *fs)
{
  gtk_entry_set_text(GTK_ENTRY (output_entry),gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  gtk_widget_destroy(report_selector);
}

void select_report_file(GtkWidget *w, gpointer data) 
{
  report_selector = gtk_file_selection_new ("File report");
   gtk_signal_connect (GTK_OBJECT (report_selector), "destroy",
		      (GtkSignalFunc) gtk_widget_destroy, &report_selector);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (report_selector)->ok_button),
		      "clicked", (GtkSignalFunc) set_report_file, report_selector );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (report_selector)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (report_selector));  
  gtk_widget_show(report_selector); 
}






void open_report_dialog(GtkWidget *w, gpointer data)
{
  GtkWidget *report_dialog_window;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *frame;
  GtkWidget *check;
  GtkWidget *table;
  GtkWidget *output_button;
  GtkWidget *button;
  
  GList *disk_list;
  GList *cat_list;
  GSList *group;

  int i;
 
  report_disks = 0;
  report_folders = 0;
  report_files = 0;
  report_location = 0;
  report_description = 0;
  report_just_commented = 0;
  sort_by_cat = 1;
  report_category = 0;
  report_just_with_category = 0;

  report_dialog_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize( GTK_WIDGET (report_dialog_window), 290, 305);
  gtk_container_border_width (GTK_CONTAINER (report_dialog_window), 10);
  gtk_window_set_policy(GTK_WINDOW(report_dialog_window), FALSE, FALSE, TRUE);
  gtk_window_set_title(GTK_WINDOW (report_dialog_window), "Report generator");
  /*    gtk_signal_connect(GTK_OBJECT (report_dialog_window), "delete_event",
	exit_report_dialog, report_dialog_window);*/
  gtk_widget_show(report_dialog_window);
  
  
  vbox = gtk_vbox_new(FALSE,4);
  gtk_container_add( GTK_CONTAINER(report_dialog_window),vbox);
  gtk_widget_show(vbox);
  
  /**************/
  hbox = gtk_hbox_new(FALSE,0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox); 
  
  label = gtk_label_new("Disk:         ");
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  
  disk_combo = gtk_combo_new(); 
  gtk_combo_set_value_in_list(GTK_COMBO(disk_combo), FALSE, TRUE); 
  gtk_combo_set_use_arrows_always(GTK_COMBO(disk_combo), TRUE); 
  gtk_combo_disable_activate(GTK_COMBO(disk_combo)); 
  
  disk_list=NULL;	
  for(i=0;i<racine.nb_folders;i++) disk_list = g_list_append(disk_list, racine.folders[i].name);
  disk_list = g_list_append(disk_list, "All disks");
  gtk_combo_set_popdown_strings(GTK_COMBO(disk_combo), disk_list);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(disk_combo)->entry), FALSE);    
  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(disk_combo)->entry), "All disks");
  /* gtk_signal_connect(GTK_OBJECT(GTK_COMBO(disk_combo)->entry), "activate",
     start_search,
     GTK_OBJECT (search_dialog_window));*/
  gtk_box_pack_start (GTK_BOX (hbox), disk_combo, FALSE, FALSE, 0);
  gtk_widget_show (disk_combo);
  
  /********/
  
  
  hbox = gtk_hbox_new(FALSE,0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox); 
  
  label = gtk_label_new("Category:  ");
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  
  cat_combobox = gtk_combo_new(); 
  gtk_combo_set_value_in_list(GTK_COMBO(cat_combobox), FALSE, TRUE); 
  gtk_combo_set_use_arrows_always(GTK_COMBO(cat_combobox), TRUE); 
  gtk_combo_disable_activate(GTK_COMBO(cat_combobox)); 
  
  cat_list=NULL;	
  for(i=0;i<nb_categories;i++) cat_list = g_list_append(cat_list, categories[i]);
  cat_list = g_list_append(cat_list, "All categories");
  gtk_combo_set_popdown_strings(GTK_COMBO(cat_combobox), cat_list);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cat_combobox)->entry), FALSE);    
  gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(cat_combobox)->entry), "All categories");
  /* gtk_signal_connect(GTK_OBJECT(GTK_COMBO(cat_combobox)->entry), "activate",
     start_search,
     GTK_OBJECT (search_dialog_window));*/
  gtk_box_pack_start (GTK_BOX (hbox), cat_combobox, FALSE, FALSE, 0);
  gtk_widget_show (cat_combobox);
  
  /*********/
  
  frame = gtk_frame_new(NULL);
  gtk_frame_set_label( GTK_FRAME(frame), "Include to report" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show(frame);
  
  table = gtk_table_new(3, 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table);
  gtk_widget_show(table);
  
  check = gtk_check_button_new_with_label("Disks");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 0, 1, 0, 1);
  gtk_widget_show (check);
  
  check = gtk_check_button_new_with_label("Folders");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)1);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 0, 1, 1, 2);
  gtk_widget_show (check);
  
  check = gtk_check_button_new_with_label("Files");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)2);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 0, 1, 2, 3);
  gtk_widget_show (check);
  
  check = gtk_check_button_new_with_label("Category");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)7);
  //gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 0, 1, 3, 4);
  gtk_widget_show (check);
  
  check = gtk_check_button_new_with_label("Location");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)3);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 1, 2, 0, 1);
  gtk_widget_show (check);
  
  check = gtk_check_button_new_with_label("Descriptions");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)4);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 1, 2, 1, 2);
  gtk_widget_show (check);
  
  check = gtk_check_button_new_with_label("Only items with description");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)5);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 1, 2, 2, 3);
  gtk_widget_show (check);
  
  check = gtk_check_button_new_with_label("Only items with category");
  gtk_signal_connect (GTK_OBJECT(check), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)8);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
  gtk_table_attach_defaults (GTK_TABLE(table), check, 1, 2, 3, 4);
  gtk_widget_show (check);
  
  /************/
  frame = gtk_frame_new(NULL);
  gtk_frame_set_label( GTK_FRAME(frame), "Sort by" );
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show(frame);
  
  hbox = gtk_hbox_new(FALSE,2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_border_width(GTK_CONTAINER(hbox), 3);
  gtk_widget_show(hbox); 
  
  button = gtk_radio_button_new_with_label (NULL, "Category");
  gtk_signal_connect (GTK_OBJECT(button), "toggled",
		      GTK_SIGNAL_FUNC(button_checked), (int *)6);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  
  group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
  button = gtk_radio_button_new_with_label(group, "Disk->folder->File");
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  
  /************/
  frame = gtk_frame_new(NULL);
  //gtk_frame_set_label( GTK_FRAME(frame), "Output File:" );
  //gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show(frame);
  
  hbox = gtk_hbox_new(FALSE,2);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_border_width(GTK_CONTAINER(hbox), 3);
  gtk_widget_show(hbox); 
  
  label = gtk_label_new("Output file: ");
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  
  output_entry = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (hbox), output_entry, FALSE, FALSE, 0);
  gtk_widget_show(output_entry);
  
  output_button=gtk_button_new_with_label(" . . . ");
  gtk_signal_connect(GTK_OBJECT(output_button),"clicked",GTK_SIGNAL_FUNC(select_report_file),report_dialog_window);
  gtk_box_pack_start(GTK_BOX(hbox),output_button,FALSE,FALSE,0);
  gtk_widget_show(output_button);
  
  /*******************/
  /* Et c'est le tour de la petite boite a boutons! */
  hbox = gtk_hbutton_box_new();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 0);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbox), 0, 0);
  
  gtk_container_border_width(GTK_CONTAINER(hbox), 1);
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE, FALSE, 0 );
  gtk_widget_show(hbox);
  
  button=gtk_button_new_with_label("Create report");
  gtk_object_set_user_data(GTK_OBJECT(button),report_dialog_window);
  GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
  gtk_window_set_default(GTK_WINDOW(report_dialog_window),button);
  gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(begin_report),report_dialog_window);
  gtk_widget_show(button);
  
  button=gtk_button_new_with_label("Exit");
  GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,TRUE,0);
  gtk_signal_connect_object(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(report_dialog_window));
  gtk_widget_show(button);

}
