#!/usr/local/bin/perl
#  txn-list.pl - Graphs running balance.
#
#  Modified by Arlindo L. Oliveira (aml@inesc.pt)
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: txn-list.pl,v 1.1.1.1 1999/12/18 02:06:56 curt Exp $


package CBB;

use strict;    # don't take no guff

my($tmp, $temp, $cbb_incl_dir);
my($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my($credit_total, $debit_total, $amt, $lkey, $lcat, $subtotal);
my($tcom, $tamt, $tcat, $trans, $remaining, $gtotal);
my(@keys, %ALLTRANS, @splits);
my($graphpath, $account, $name, $result);

# specify the installed location of the necessary pieces.
BEGIN {
  $CBB::cbb_incl_dir = "..";
  # print "$cbb_incl_dir\n";
  unshift(@INC, $CBB::cbb_incl_dir);
}

$graphpath = "$cbb_incl_dir/graphs";

require "flush.pl";

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

my($date_fmt, $fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";


%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $trans) = split(/\t/, $result, 2);
	($date, $remaining) = split(/\t/, $trans, 2);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {
            $ALLTRANS{"$key$name"} = $trans;
        }

        $result = &next_trans();
    }
}


# sort and print

if ( ! -x "$graphpath/graphbal") {
    die "Cannot launch $graphpath/graphbal\n";
}

open(DATA, "| $graphpath/graphbal") || die "Cannot launch graph\n";

$gtotal = 0.00;

foreach $key (sort (keys %ALLTRANS) ) {
    # print $ALLTRANS{$key} . "\n";
    ($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total) =
	split(/\t/, $ALLTRANS{$key});

#    $gtotal += $credit - $debit;

    print DATA "$date $total\n" if $total;
}

close(DATA);
