/*  xxApplicationDefaults  Settings from XResources.
    Last modified 1998-04-15

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xtide.hh"

xxApplicationDefaults::xxApplicationDefaults (XrmDatabase database) {
  XrmValue xv;
  char *str_type[20]; // Waste.

  if (XrmGetResource (database, "xtide*background", "XTide*background", str_type, &xv))
    colors[Colors::background] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*foreground", "XTide*foreground", str_type, &xv))
    colors[Colors::foreground] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*markcolor", "XTide*markcolor", str_type, &xv))
    colors[Colors::mark] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*mslcolor", "XTide*mslcolor", str_type, &xv))
    colors[Colors::msl] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*buttoncolor", "XTide*buttoncolor", str_type, &xv))
    colors[Colors::button] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*daycolor", "XTide*daycolor", str_type, &xv))
    colors[Colors::daytime] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*datumcolor", "XTide*datumcolor", str_type, &xv))
    colors[Colors::datum] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*ebbcolor", "XTide*ebbcolor", str_type, &xv))
    colors[Colors::ebb] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*floodcolor", "XTide*floodcolor", str_type, &xv))
    colors[Colors::flood] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*nightcolor", "XTide*nightcolor", str_type, &xv))
    colors[Colors::nighttime] = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*units", "XTide*units", str_type, &xv))
    u = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*zulu", "XTide*zulu", str_type, &xv))
    z = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*extralines", "XTide*extralines", str_type, &xv))
    el = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*datefmt", "XTide*datefmt", str_type, &xv))
    df = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*hourfmt", "XTide*hourfmt", str_type, &xv))
    hf = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*timefmt", "XTide*timefmt", str_type, &xv))
    tf = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*toplines", "XTide*toplines", str_type, &xv))
    tl = (char *)xv.addr;
  if (XrmGetResource (database, "xtide*nofill", "XTide*nofill", str_type, &xv))
    nf = (char *)xv.addr;

  if (XrmGetResource (database, "xtide*gaspect", "XTide*gaspect", str_type, &xv)) {
    ga_isnull = 0;
    ga = getposdouble ((char *)xv.addr);
  }
  if (XrmGetResource (database, "xtide*globelongitude", "XTide*globelongitude", str_type, &xv)) {
    gl_isnull = 0;
    gl = getgldouble ((char *)xv.addr);
  }
  if (XrmGetResource (database, "xtide*gheight", "XTide*gheight", str_type, &xv)) {
    gh_isnull = 0;
    gh = max (mingheight, getposint ((char *)xv.addr));
  }
  if (XrmGetResource (database, "xtide*gwidth", "XTide*gwidth", str_type, &xv)) {
    gw_isnull = 0;
    gw = max (mingwidth, getposint ((char *)xv.addr));
  }
  if (XrmGetResource (database, "xtide*ttyheight", "XTide*ttyheight", str_type, &xv)) {
    th_isnull = 0;
    th = max (minttyheight, getposint ((char *)xv.addr));
  }
  if (XrmGetResource (database, "xtide*ttywidth", "XTide*ttywidth", str_type, &xv)) {
    tw_isnull = 0;
    tw = max (minttywidth, getposint ((char *)xv.addr));
  }
  if (XrmGetResource (database, "xtide*lwidth", "XTide*lwidth", str_type, &xv)) {
    lw_isnull = 0;
    lw = getposdouble ((char *)xv.addr);
  }
  if (XrmGetResource (database, "xtide*cwidth", "XTide*cwidth", str_type, &xv)) {
    cw_isnull = 0;
    cw = max (mingwidth, getposint ((char *)xv.addr));
  }
}

char
*xxApplicationDefaults::settingsid() {
  return "X resources database";
}
