/*
    Copyright (C) 1996-1999  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA.
*/

#include "../config.h"

#include "../common/richchar.h"

#if 0
extern Font get_font(int);
extern XFontStruct *font_struct(int);
#endif
extern int font_height(int);
extern int font_ascent(int);
extern int font_descent(int);
extern int font_width(int, char *);

extern void init_format(Display *);

extern unsigned long get_color(int);

/* and now the new format code */
/* Here, the red, green and blue fields are present despite that
   identical fields exist in the XColor structure. This is to allow
   non-X ports.
*/
typedef struct {
	char *name;
	unsigned short red, green, blue;
	char need_init;
	XColor color;
} siag_color;

/* this structure holds the XLFD name including point size and resolution,
   the Postscript name and the corresponding X font structure */
typedef struct {
	int name;		/* index into fontname table */
	char *x_name;		/* encoded X font name */
	char *ps_name;		/* encoded PS font name */
	char *t1_name;		/* encoded T1 font name */
	XFontStruct *fs;	/* X11 font structure */
	int id;			/* T1 font id */
	int size;		/* in decipoints */
	char bold, italic;
} siag_font;

/* A structure with the name seen by the user followed by four X font names
   in XLFD format and four PS font names. The four are for plain, italic,
   bold and bold italic. The x font names are of this format (example):
   -*-helvetica-medium-o-*--*-%d-%d-%d-*-*-*-*
   The three %d fields are for point size in decipoints, x resolution
   and y resolution. They are filled in by encode_font.
*/
typedef struct {
	char *name;
	char *x_name[4];
	char *ps_name[4];
	char *t1_name[4];
	int iso8859_1;	/* should we try to do IsoLatin1 encoding? */
} siag_fontname;

extern siag_color color_table[];
extern siag_font font_table[];
extern int lookup_color(char *);
extern int lookup_font(char *, int, int, int);

extern int rc_width(rich_char);
extern int rc_height(rich_char);
extern void rc_geom(rich_char, int *, int *);
extern int rc_strwidth(rich_char *, int);
extern int rc_strheight(rich_char *, int);
extern void rc_strgeom(rich_char *, int, int *, int *);
extern int rc_draw(Drawable, GC, int, int, rich_char, int);
extern int rc_strdraw(Drawable, GC, int, int, rich_char *, int);
extern int t1_getfontid(char *);
extern char *t1_getfontname(int);
extern int t1_init(Widget);
extern int t1_exit(void);

