
/* 
 * HandleP.h - Private definitions for Handle widget
 * 
 */

#ifndef s_XawHandleP_h
#define s_XawHandleP_h

#include "Handle.h"
#include <X11/Xaw3d/LabelP.h>

/************************************
 *
 *  Class structure
 *
 ***********************************/

   /* New fields for the Handle widget class record */
typedef struct s_HandleClass {
    int makes_compiler_happy;  /* not used */
} HandleClassPart;

   /* Full class record declaration */
typedef struct s_HandleClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    ThreeDClassPart	threeD_class;
    LabelClassPart	label_class;
    HandleClassPart    handle_class;
} HandleClassRec;

extern HandleClassRec handleClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

    /* New fields for the Handle widget record */
typedef struct {
    /* resources */
	Widget victim;
	void (*detach)(Widget);
	void (*attach)(Widget);

    /* private state */
	Boolean detached;
	Widget shell;
	Widget parent;
	Position old_x, old_y;
	Time oldtime;
	Boolean mwm, managed;
} HandlePart;


   /* Full widget declaration */
typedef struct s_HandleRec {
    CorePart         core;
    SimplePart	     simple;
    ThreeDPart       threeD;
    LabelPart	     label;
    HandlePart      handle;
} HandleRec;

#endif /* s_XawHandleP_h */


