#!/usr/local/bin/python
#
# Copyright 1997 Thierry Bousch
# Licensed under the Gnu Public License, Version 2
#
# $Id: saml0.py,v 1.2 1997/04/15 21:08:59 bousch Exp $
#
# Python bindings to the saml utility programs
#

import sys, string, os, popen2

class samuel:

  def __init__(self, sparse=0, integers=0, tensors=0, debug=0):
    cmdname = 'exec samuel -b'
    if integers:
      cmdname = cmdname + ' -Z'
    if tensors:
      cmdname = cmdname + ' -t'
    if sparse:
      cmdname = cmdname + ' --sparse'
    (self.rfd,self.wfd) = popen2.popen2(cmdname)
    self.debug = debug

  def send(self, string):
    if self.debug:
      sys.stderr.write('S> ' + command)
    self.wfd.write(string)
    self.wfd.flush()

  def read(self):
    if self.debug:
      sys.stderr.write('S< ')
    answer = self.rfd.readline()
    if self.debug:
      sys.stderr.write(answer)
    return answer[:-1]

  def assign(self, varname, expr):
    self.send('%s = %s;\n' % (varname, expr))

  def compute(self, expr):
    self.send(expr + ';\n')
    return self.read()

  def __getitem__(self, var):
    return self.compute('?'+var)

  def __setitem__(self, var, value):
    self.assign(var, value)

#
# End of class definitions
#

def isprime(number):
  p = os.popen('exec factorint -t -- '+number, 'r')
  answer = p.readline()
  if answer == 'prime\n':
    return 1
  else:
    return 0

def factorize(number):
  p = os.popen('exec factorint -- '+number, 'r')
  answer = p.readline()[:-1]
  a = []
  if answer[0] == '-':
    a = [('-1',1)]
    answer = answer[1:]
  for ne in string.split(answer, '.'):
    arr = string.split(ne, '^')
    if len(arr)==2:
      a.append((arr[0],string.atoi(arr[1])))
    elif ne<>'1':
      a.append((ne,1))
  return a

def test():
  debug = 0
  if len(sys.argv)==2 and sys.argv[1]=='-d':
    debug = 1
  s = samuel(debug)
  s.assign('fact', '1')
  for i in xrange(201):
    if i:
      s.assign('fact', '?fact * '+`i`)
    fact = s.compute('?fact')
    print '%d\t%s' % (i,fact)

if __name__ == '__main__':
  test()
