%etextxy(epsFile,x,y,rotation,alignment,text,font,size,color)
% this function write postscript commands in  epsFile to draw a West scale
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function etextxy(epsFile,x,y,rotation,alignment,text,font,size,color)
  if (nargin~=9)
    usage('etextxy(epsFile,x,y,rotation,alignment,text,font,size,color)');
  end
  fprintf(epsFile,'currentrgbcolor %1.2f %1.2f %1.2f setrgbcolor\n',...
          color(1),color(2),color(3));
  if x~=0
    fprintf(epsFile,'%1.2f %1.2f moveto\n',x,y);
  else
    alignment=1;
    fprintf(epsFile,'lastX lastY moveto 0 %1.2f rmoveto\n',y);
  end
  fprintf(epsFile,'/%s findfont %1.2f scalefont setfont\n',font,size);
  fprintf(epsFile,'%1.2f rotate\n',rotation);
  if alignment==0
    fprintf(epsFile,...
      '(%s) dup stringwidth pop dup 2 div sub neg 0 rmoveto show\n',text);
  elseif alignment>0
    fprintf(epsFile,...
      '(%s) show\n',text);
  else
    fprintf(epsFile,...
      '(%s) dup stringwidth pop neg 0 rmoveto show\n',text);
  end
  fprintf(epsFile,'currentpoint /lastY exch def /lastX exch def\n');
  fprintf(epsFile,'%1.2f rotate\n',-rotation);
  fprintf(epsFile,'setrgbcolor\n');
