%%NAME
%%  eshadow  - make shadow image matrix
%%
%%SYNOPSIS
%%  x=eshadow(matrix,nColors,colorMap,lumen)
%%
%%PARAMETER(S)
%%  matrix             matrix for image 
%%  nColors            number of brightness levels 
%%  colorMap           one or more Colors, n x 3 Matrix 
%%  lumen              light direction, [x,y,z] vector
%%
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function x=eshadow(matrix,nColors,colorMap,lumen)
  if nargin ~= 4
    usage('x=eshadow(matrix,nColors,colorMap,lumen)');
  end
  nMapItems=size(colorMap,1);
  nBrightnessLevels=nMapItems/nColors;

  darkAngle=-0.5;
  brightnessConst=nBrightnessLevels/(1-darkAngle)*1.001;

  [rows colums]=size(matrix);  
  neightbourE=[matrix(:,2:colums) matrix(:,colums)];
  neightbourS=[matrix(2:rows,:);matrix(rows,:)];
  neightbourE=neightbourE-matrix;
  neightbourS=matrix-neightbourS;
  square=neightbourE.*neightbourE+neightbourS.*neightbourS;
  sumAmount= sum(sum(sqrt(square)));
  averageAmount=sumAmount/rows/colums; 
  neightbourE=neightbourE/averageAmount;
  neightbourS=neightbourS/averageAmount;
  square=neightbourE.*neightbourE+neightbourS.*neightbourS;
  lumen=lumen/norm(lumen)*sqrt(2);
  brightness=fix(brightnessConst*...
    ((-neightbourE*lumen(1)+(-neightbourS)*lumen(2)+lumen(3))./...
    sqrt(2*(square+1))-darkAngle));
  brightness=reshape(brightness,rows*colums,1);
  search=find(brightness<1);
  if length(search)>0
    brightness(search)=ones(length(search),1);
  end
  brightness=reshape(brightness,rows,colums);
  maxValue=max(max(matrix));
  minValue=min(min(matrix));
  if (maxValue==minValue)
    matrix=ones(size(matrix,1),size(matrix,2));
  else
    matrix=fix((matrix-minValue)/(maxValue-minValue)*(nColors-1))+1; 
  end
  x=matrix+(brightness-1)*nColors;
  x=x(1:rows-1,1:colums-1);
