%escalepr(epsFile,x,y,minRadius,maxRadius,angle1,angle2,startValue,step,...
%         endValue,vForm,vVisible,fontSize,lineWidth,shortTicLength,...
%         longTicLength,maxValues,space)
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function escalepr(epsFile,x,y,minRadius,maxRadius,angle1,angle2,startValue,...
                  step,endValue,vForm,vVisible,fontSize,lineWidth,...
                  shortTicLength,longTicLength,maxValues,space)
  if (nargin~=18)
    usage(...
   'escalepr(epsFile,x,y,minRadius,maxRadius,angle1,angle2,startValue,step,endValue,vForm,vVisible,fontSize,lineWidth,shortTicLength,longTicLength,maxValues,space)');
  end
  startPos=minRadius;
  length=maxRadius-minRadius;
  xLength=length;
  yLength=0;
  moveForm='%1.2f 0 moveto\n';
  ticLineForm='0 %1.2f neg rlineto\n';
  moveValueForm=sprintf('%1.2f %1.2f neg rmoveto\n',space,...
                        space+fontSize+2-longTicLength);
  showForm='(%s) show\n';
  startEndDiff=endValue-startValue;
  if step==0
    %autoscale
    signOfDelta=sign(startEndDiff);
    deltaLabel=eticdis(signOfDelta*startEndDiff,maxValues);
  else
    %fixscale
    signOfDelta=sign(step);
    deltaLabel=signOfDelta*step;
  end
  if vForm==0  
    expo=-log10(deltaLabel);
    if rem(expo,1)>0
      expo=expo+1;
    end
    autoForm=fix(expo);
    if autoForm>0
      vForm=autoForm;
    end
  end
  %start ticNo and offset
  nShortTics=rem(startValue,deltaLabel)/deltaLabel*5*signOfDelta;
  if nShortTics<0
    nShortTics=5+nShortTics;
  end
  if rem(nShortTics,1)>0
      i=fix(nShortTics)+1;
      ticOffset=(i-nShortTics)*signOfDelta*deltaLabel/5;
  else 
    i=nShortTics; 
    ticOffset=0;
  end
  firstTicValue=startValue+ticOffset;
  currentValue=firstTicValue;
  deltaTic=signOfDelta*deltaLabel/5;
  axisFac=length/startEndDiff;
  
  % start draw
  fprintf(epsFile,'%1.2f %1.2f translate\n',x,y);
  fprintf(epsFile,'%1.2f rotate\n',angle1);
  fprintf(epsFile,'newpath\n');
  fprintf(epsFile,'/Helvetica findfont %d scalefont setfont\n',fontSize);

  %tics
  currentTic=0;
  currentValue=firstTicValue;
  while signOfDelta*currentValue<=signOfDelta*endValue
    currentPos=startPos+axisFac*(currentValue-startValue);
    fprintf(epsFile,moveForm,currentPos);
    if rem(i,5)~=0
      % short tics
      fprintf(epsFile,ticLineForm,shortTicLength);
    else
      % long tics
      fprintf(epsFile,ticLineForm,longTicLength);
      % value
      if vVisible
        fprintf(epsFile,moveValueForm);
        valueForm=sprintf('%%1.%df',vForm);
        valueForm=sprintf(valueForm,currentValue);
        fprintf(epsFile,showForm,valueForm);
      end
    end
    i=i+1;
    currentTic=currentTic+1;
    currentValue=firstTicValue+currentTic*deltaTic;
  end

  %axis
  fprintf(epsFile,moveForm,startPos);
  fprintf(epsFile,'%1.2f %1.2f rlineto\n',xLength,yLength);
  fprintf(epsFile,'%1.2f rotate\n',angle2-angle1);
  fprintf(epsFile,moveForm,startPos);
  fprintf(epsFile,'%1.2f %1.2f rlineto\n',xLength,yLength);
  fprintf(epsFile,'%1.2f setlinewidth\n',lineWidth);
  fprintf(epsFile,'stroke\n');
  fprintf(epsFile,'%1.2f rotate\n',-angle2);
  fprintf(epsFile,'%1.2f %1.2f translate\n',-x,-y);
