%%NAME
%%  eopen  - open EPS-file, define size of page, size of window and
%%           call 'einit' to initialize the global parameter
%%
%%SYNOPSIS
%%  eopen([ epsFileName[,pageOrientation[,winWidth,winHeight]]])
%%        [,origin[,pageScaleFac]]]]])
%%
%%PARAMETER(S)
%%  epsFileName       name of eps-file (default name is defined as eFileName)
%%  pageOrientation   page orientation,
%%                    0=portrait 1=landscape 2=upside-down 3=seaside
%%  winWidth          width of window(=eps bounding-box)
%%  winHeight         height of window(=eps bounding-box)
%%  origin            vector of origin, [xOffset yOffset]
%%  pageScaleFac      scale factor in percent, 1:1=100  1:2=50  2:1=200 
%% 
%%GLOBAL PARAMETER(S)
%%  eFileName
%%  ePageWidth
%%  ePageHeight
%%  ePageScaleFac
%%  ePageOrientation
%%  eUserUnit
%%  eWinWidth
%%  eWinHeight
%%  eWinOrigin
%%  eFonts
% written by Stefan Mueller stefan.mueller@fgan.de

function eopen(epsFileName,pageOrientation,winWidth,winHeight,origin,pageScaleFac)
  if nargin>6 | nargin==3
    usage ('eopen ( [ epsFileName[,pageOrientation,[winWidth,winHeight[,origin[,pageScaleFac]]]] )');
  end
  eglobpar;
  einit;
  ePlotLineNr=0;
  ePolarPlotLineNr=0;
  if nargin>0
    eFileName=epsFileName;
  end
  if nargin>1
    ePageOrientation=pageOrientation;
  end
  if nargin==2 & rem(ePageOrientation,2)
    winW=eWinWidth;
    eWinWidth=eWinHeight;
    eWinHeight=winW;
  end
  if nargin>3
    eWinWidth=winWidth;
    eWinHeight=winHeight;
  end
  if nargin>4
    eWinOrigin=origin;
  end
  if nargin>5
    ePageScaleFac=pageScaleFac;
  end
  
  % open eps file
  eFile=fopen(eFileName,'w');
  if eFile<0
    errortext=sprintf('cant open %s',eFileName);
    error (errortext);
  end


  % set user units
  if strcmp(eUserUnit,'mm')
    eFac=2.834646;
  elseif strcmp(eUserUnit,'cm')
    eFac=28.34646;
  elseif strcmp(eUserUnit,'inch')
    eFac=72;
  else 
    eFac=1;
  end
  
  % write eps head
  ehead(eFile,eWinWidth*eFac,eWinHeight*eFac,...
        ePageWidth*eFac,ePageHeight*eFac,...
        ePageOrientation,ePageScaleFac);

  % reencode fonts
  newFonts=erencode(eFile,eFonts(1,:));
  for i=2:size(eFonts,1)
    newFonts=[newFonts;erencode(eFile,eFonts(i,:))];
  end
  eFonts=newFonts;
  fprintf(eFile,'%1.2f %1.2f translate\n',...
          eWinOrigin(1)*eFac,eWinOrigin(2)*eFac);
