/*  This file adapted from Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "gtkplot.h"
#include "gtkplotlayout.h"
#include "gtkplotcanvas.h"
#include "gtkplotps.h"
#include "gtksheet.h"

#include "app.h"
#include "print.h"

#define MAX_PRINT_COMMAND_LEN  256

extern GtkWidget *canvas;

GtkWidget *frmPrint;
gboolean PrintOpen = FALSE;
static GtkWidget *frmPrintFileSel;

GtkWidget* get_widget (GtkWidget *widget, gchar *widget_name);


GtkWidget* create_frmPrint (void)
{
    GtkWidget *vbox1;
    GtkWidget *table1;
    GtkWidget *lblPrintTo;
    GSList *radGrpPrintTo_group = NULL;
    GtkWidget *radPrinter;
    GtkWidget *radFile;
    GtkWidget *lblCommand;
    GtkWidget *txtCommand;
    GtkWidget *hseparator1;
    GtkWidget *hbox3;
    GtkWidget *hbox4;
    GtkWidget *lblCopies;
    GtkObject *spinCopies_adj;
    GtkWidget *spinCopies;
    GtkWidget *hseparator3;
    GtkWidget *hbox5;
    GtkWidget *hbox6;
    GtkWidget *cmdPrint;
    GtkWidget *cmdCancel;
    

    PrintOpen = TRUE;

    frmPrint = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_widget_set_name (frmPrint, "frmPrint");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "frmPrint", frmPrint);
    gtk_widget_set_usize (frmPrint, 300, 150);
    gtk_container_border_width (GTK_CONTAINER (frmPrint), 6);
    gtk_signal_connect_object (GTK_OBJECT (frmPrint), "destroy",
			       GTK_SIGNAL_FUNC (on_frmPrint_destroy),
			       GTK_OBJECT (frmPrint));
    gtk_window_set_title (GTK_WINDOW (frmPrint), _("Print"));
    
    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_set_name (vbox1, "vbox1");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "vbox1", vbox1);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (frmPrint), vbox1);
    
    table1 = gtk_table_new (2, 5, TRUE);
    gtk_widget_set_name (table1, "table1");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "table1", table1);
    gtk_widget_show (table1);
    gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 2);
    gtk_table_set_row_spacings (GTK_TABLE (table1), 6);
    gtk_table_set_col_spacings (GTK_TABLE (table1), 3);
    
    lblPrintTo = gtk_label_new (_("Print to:"));
    gtk_widget_set_name (lblPrintTo, "lblPrintTo");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "lblPrintTo", lblPrintTo);
    gtk_widget_show (lblPrintTo);
    gtk_table_attach (GTK_TABLE (table1), lblPrintTo, 0, 1, 0, 1,
		      (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
    gtk_label_set_justify (GTK_LABEL (lblPrintTo), GTK_JUSTIFY_RIGHT);
    
    radPrinter = gtk_radio_button_new_with_label (radGrpPrintTo_group, _("Printer"));
    radGrpPrintTo_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radPrinter));
    gtk_widget_set_name (radPrinter, "radPrinter");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "radPrinter", radPrinter);
    gtk_widget_show (radPrinter);
    gtk_table_attach (GTK_TABLE (table1), radPrinter, 1, 2, 0, 1,
		      (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radPrinter), TRUE);
    
    radFile = gtk_radio_button_new_with_label (radGrpPrintTo_group, _("File"));
    radGrpPrintTo_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radFile));
    gtk_widget_set_name (radFile, "radFile");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "radFile", radFile);
    gtk_widget_show (radFile);
    gtk_table_attach (GTK_TABLE (table1), radFile, 2, 3, 0, 1,
		      (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
    
    lblCommand = gtk_label_new (_("Printer Command:"));
    gtk_widget_set_name (lblCommand, "lblCommand");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "lblCommand", lblCommand);
    gtk_widget_show (lblCommand);
    gtk_table_attach (GTK_TABLE (table1), lblCommand, 0, 2, 1, 2,
		      (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
    gtk_misc_set_alignment (GTK_MISC (lblCommand), 0.4, 0.5);
    
    txtCommand = gtk_entry_new_with_max_length (MAX_PRINT_COMMAND_LEN);
    gtk_widget_set_name (txtCommand, "txtCommand");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "txtCommand", txtCommand);
    gtk_widget_show (txtCommand);
    gtk_table_attach (GTK_TABLE (table1), txtCommand, 2, 5, 1, 2,
		      (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 2, 1);
    gtk_entry_set_text (GTK_ENTRY (txtCommand), "lpr");
    
    hseparator1 = gtk_hseparator_new ();
    gtk_widget_set_name (hseparator1, "hseparator1");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "hseparator1", hseparator1);
    gtk_widget_show (hseparator1);
    gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 0);
    
    hbox3 = gtk_hbox_new (FALSE, 0);
    gtk_widget_set_name (hbox3, "hbox3");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "hbox3", hbox3);
    gtk_widget_show (hbox3);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);
    
    hbox4 = gtk_hbox_new (FALSE, 0);
    gtk_widget_set_name (hbox4, "hbox4");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "hbox4", hbox4);
    gtk_widget_show (hbox4);
    gtk_box_pack_start (GTK_BOX (hbox3), hbox4, TRUE, TRUE, 0);
    
    lblCopies = gtk_label_new (_("Copies:"));
    gtk_widget_set_name (lblCopies, "lblCopies");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "lblCopies", lblCopies);
    gtk_widget_show (lblCopies);
    gtk_box_pack_start (GTK_BOX (hbox4), lblCopies, TRUE, TRUE, 0);
    gtk_misc_set_alignment (GTK_MISC (lblCopies), 0.8, 0.5);
    
    spinCopies_adj = gtk_adjustment_new (1, 1, 50, 1, 10, 10);
    spinCopies = gtk_spin_button_new (GTK_ADJUSTMENT (spinCopies_adj), 1, 0);
    gtk_widget_set_name (spinCopies, "spinCopies");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "spinCopies", spinCopies);
    gtk_widget_show (spinCopies);
    gtk_box_pack_start (GTK_BOX (hbox4), spinCopies, FALSE, TRUE, 0);
    gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinCopies), TRUE);
    
    hseparator3 = gtk_hseparator_new ();
    gtk_widget_set_name (hseparator3, "hseparator3");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "hseparator3", hseparator3);
    gtk_widget_show (hseparator3);
    gtk_box_pack_start (GTK_BOX (vbox1), hseparator3, TRUE, TRUE, 0);
    
    hbox5 = gtk_hbox_new (FALSE, 0);
    gtk_widget_set_name (hbox5, "hbox5");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "hbox5", hbox5);
    gtk_widget_show (hbox5);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox5, TRUE, TRUE, 0);
    
  
    
    hbox6 = gtk_hbox_new (TRUE, 8);
    gtk_widget_set_name (hbox6, "hbox6");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "hbox6", hbox6);
    gtk_widget_show (hbox6);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox6, TRUE, TRUE, 0);
    
    cmdPrint = gtk_button_new_with_label (_("Print"));
    gtk_widget_set_name (cmdPrint, "cmdPrint");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "cmdPrint", cmdPrint);
    gtk_widget_show (cmdPrint);
    gtk_box_pack_start (GTK_BOX (hbox6), cmdPrint, TRUE, TRUE, 0);
    gtk_container_border_width (GTK_CONTAINER (cmdPrint), 3);
    gtk_signal_connect_object (GTK_OBJECT (cmdPrint), "clicked",
			       GTK_SIGNAL_FUNC (on_cmdPrint_clicked),
			       GTK_OBJECT (cmdPrint));

    cmdCancel = gtk_button_new_with_label (_("Cancel"));
    gtk_widget_set_name (cmdCancel, "cmdCancel");
    gtk_object_set_data (GTK_OBJECT (frmPrint), "cmdCancel", cmdCancel);
    gtk_widget_show (cmdCancel);
    gtk_box_pack_start (GTK_BOX (hbox6), cmdCancel, TRUE, TRUE, 0);
    gtk_container_border_width (GTK_CONTAINER (cmdCancel), 3);
    gtk_signal_connect_object (GTK_OBJECT (cmdCancel), "clicked",
			       GTK_SIGNAL_FUNC (on_cmdPrintCancel_clicked),
			       GTK_OBJECT (cmdCancel));
    
  return frmPrint;
}

GtkWidget* create_frmPrintFileSel ()
{
    GtkWidget *frmPrintFileSel;
    GtkWidget *ok_button;
    GtkWidget *cancel_button;
    
    frmPrintFileSel = gtk_file_selection_new (_("Print To File"));
    gtk_widget_set_name (frmPrintFileSel, "frmPrintFileSel");
    gtk_object_set_data (GTK_OBJECT (frmPrintFileSel), "frmPrintFileSel", frmPrintFileSel);
    gtk_container_border_width (GTK_CONTAINER (frmPrintFileSel), 10);
    gtk_signal_connect_object (GTK_OBJECT (frmPrintFileSel), "destroy",
			       GTK_SIGNAL_FUNC (on_frmPrintFileSel_destroy),
			       GTK_OBJECT (frmPrintFileSel));
    
    ok_button = GTK_FILE_SELECTION (frmPrintFileSel)->ok_button;
    gtk_widget_set_name (ok_button, "ok_button");
    gtk_object_set_data (GTK_OBJECT (frmPrintFileSel), "ok_button", ok_button);
    gtk_widget_show (ok_button);
    GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
    gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
			       GTK_SIGNAL_FUNC (on_ok_button_clicked),
			       GTK_OBJECT (ok_button));
    
    cancel_button = GTK_FILE_SELECTION (frmPrintFileSel)->cancel_button;
    gtk_widget_set_name (cancel_button, "cancel_button");
    gtk_object_set_data (GTK_OBJECT (frmPrintFileSel), "cancel_button", cancel_button);
    gtk_widget_show (cancel_button);
    GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
    gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			       GTK_SIGNAL_FUNC (on_cancel_button_clicked),
			       GTK_OBJECT (cancel_button));
    
    return frmPrintFileSel;
}

void on_frmPrint_destroy (GtkObject *object, gpointer user_data)
{
    gtk_widget_destroy(frmPrint);
    PrintOpen = FALSE;
}

void on_frmPrintFileSel_destroy (GtkObject *object, gpointer user_data)
{
    gtk_widget_destroy(frmPrintFileSel);
    PrintOpen = FALSE;
}

void on_cmdPrint_clicked (GtkButton *button, gpointer user_data)
{
    GtkWidget *radFile = get_widget(frmPrint, "radFile");
    
    if (GTK_TOGGLE_BUTTON (radFile)->active)
    {
	/* Print to file is toggled */
	gtk_widget_destroy(frmPrint);
	frmPrintFileSel = create_frmPrintFileSel();
	PrintOpen = TRUE;
	gtk_widget_show(frmPrintFileSel);
    }
    else
    {
	/* We're gonna print to the printer (default) */
	print_to_printer();
    }
}

void on_cmdPrintCancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(frmPrint);
}

void on_ok_button_clicked (GtkButton *button, gpointer user_data)
{
    gchar *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(frmPrintFileSel));
    
    gtk_plot_layout_export_ps_with_size(GTK_PLOT_LAYOUT(canvas), filename, 0, 0, GTK_PLOT_PSPOINTS, 612, 612);
    
    gtk_widget_destroy(frmPrintFileSel);
}

void on_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
    gtk_widget_destroy(frmPrintFileSel);
}

void print_to_printer()
{
    GtkWidget *txtCommand   = get_widget(frmPrint, "txtCommand");
    GtkWidget *spinCopies   = get_widget(frmPrint, "spinCopies");
    gchar command[MAX_PRINT_COMMAND_LEN];
    gchar s[65]; 

    tmpnam (s); /* Get a temporary file name */
    
    g_snprintf(command, MAX_PRINT_COMMAND_LEN, "%s -K%d s",
	       gtk_entry_get_text(GTK_ENTRY(txtCommand)),
	       gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinCopies)));
    
    tmpnam (s); /* Get a temporary file name */
    
    gtk_plot_layout_export_ps_with_size(GTK_PLOT_LAYOUT(canvas), s, 0, 0, GTK_PLOT_PSPOINTS, 612, 612);
    
    
    /* Print it */
    system (command);
    
    unlink (s);
    
    
    gtk_widget_destroy(frmPrint);
}


GtkWidget* get_widget (GtkWidget *widget, gchar *widget_name)
{
    GtkWidget *parent, *found_widget;
    
    for (;;)
    {
	if (GTK_IS_MENU (widget))
	    parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
	else
	    parent = widget->parent;
	if (parent == NULL)
	    break;
	widget = parent;
    }
    
    found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
						     widget_name);
    if (!found_widget)
	g_warning ("Widget not found: %s", widget_name);
    return found_widget;
}
