#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "gtkplot.h"
#include "gtksheet.h"

#include "app.h"
#include "mathparsesym.h"
#include "mathparse.h"
#include "prefs.h"
#include "stringfuncs.h"


struct prefs prf; /* Define the prefs struct. this is used globally. */


static char *get_config_path();

GdkColormap *colormap;

extern GtkWidget *window1;
extern GtkWidget *active_plot;
extern GtkWidget *layout;

void defaults (void)
{
  /* First set up the color defaults. */

#if 0
  /*colormap = gdk_window_get_colormap (window1);

  gdk_color_parse(PREFS_DEFAULT_COLOR0, &prf.color[0]);
  gdk_color_alloc(colormap, &prf.color[0]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR1, &prf.color[1]);
  gdk_color_alloc(colormap, &prf.color[1]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR2, &prf.color[2]);
  gdk_color_alloc(colormap, &prf.color[2]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR3, &prf.color[3]);
  gdk_color_alloc(colormap, &prf.color[3]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR4, &prf.color[4]);
  gdk_color_alloc(colormap, &prf.color[4]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR5, &prf.color[5]);
  gdk_color_alloc(colormap, &prf.color[5]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR6, &prf.color[6]);
  gdk_color_alloc(colormap, &prf.color[6]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR7, &prf.color[7]);
  gdk_color_alloc(colormap, &prf.color[7]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR8, &prf.color[8]);
  gdk_color_alloc(colormap, &prf.color[8]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR9, &prf.color[9]);
  gdk_color_alloc(colormap, &prf.color[9]);
  
  gdk_color_parse(PREFS_DEFAULT_BGCOLOR, &prf.bgcolor);
  gdk_color_alloc(colormap, &prf.bgcolor);
  
  gdk_color_parse(PREFS_DEFAULT_GRIDCOLOR, &prf.gridcolor);
  gdk_color_alloc(colormap, &prf.gridcolor); */



  
  gdk_color_parse(PREFS_DEFAULT_COLOR0, &prf.color[0]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[0]);
  gtk_plot_dataset_set_line_attributes(dataset[0],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[0]);

  gdk_color_parse(PREFS_DEFAULT_COLOR1, &prf.color[1]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[1]);
  gtk_plot_dataset_set_line_attributes(dataset[1],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[1]);

  gdk_color_parse(PREFS_DEFAULT_COLOR2, &prf.color[2]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[2]);
  gtk_plot_dataset_set_line_attributes(dataset[2],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[2]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR3, &prf.color[3]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[3]);
  gtk_plot_dataset_set_line_attributes(dataset[3],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[3]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR4, &prf.color[4]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[4]);
  gtk_plot_dataset_set_line_attributes(dataset[4],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[4]);

  gdk_color_parse(PREFS_DEFAULT_COLOR5, &prf.color[5]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[5]);
  gtk_plot_dataset_set_line_attributes(dataset[5],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[5]);

  gdk_color_parse(PREFS_DEFAULT_COLOR6, &prf.color[6]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[6]);
  gtk_plot_dataset_set_line_attributes(dataset[6],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[6]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR7, &prf.color[7]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[7]);
  gtk_plot_dataset_set_line_attributes(dataset[7],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[7]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR8, &prf.color[8]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[8]);
  gtk_plot_dataset_set_line_attributes(dataset[8],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[8]);
  
  gdk_color_parse(PREFS_DEFAULT_COLOR9, &prf.color[9]);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.color[9]);
  gtk_plot_dataset_set_line_attributes(dataset[9],
                                      GTK_PLOT_LINE_SOLID,
                                      0, prf.color[9]);
#endif

  gdk_color_parse(PREFS_DEFAULT_BGCOLOR, &prf.bgcolor);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.bgcolor);

  gdk_color_parse(PREFS_DEFAULT_GRIDCOLOR, &prf.gridcolor);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.gridcolor);

  gdk_color_parse(PREFS_DEFAULT_AXISCOLOR, &prf.axiscolor);
  gdk_color_alloc(gdk_colormap_get_system(), &prf.axiscolor);
   
  /* Set booleans to defaults */
  
  prf.showvgrid = PREFS_DEFAULT_SHOWVGRID;
  prf.showhgrid = PREFS_DEFAULT_SHOWHGRID;
  prf.showlegend = PREFS_DEFAULT_SHOWLEGEND;

  prf.showtop = PREFS_DEFAULT_SHOWTOP;
  prf.showbottom = PREFS_DEFAULT_SHOWBOTTOM;
  prf.showleft = PREFS_DEFAULT_SHOWLEFT;
  prf.showright = PREFS_DEFAULT_SHOWRIGHT;
  prf.showxy = PREFS_DEFAULT_SHOWXY;

  prf.toptitle = PREFS_DEFAULT_TOPTITLE;
  prf.bottomtitle = PREFS_DEFAULT_BOTTOMTITLE;
  prf.lefttitle = PREFS_DEFAULT_LEFTTITLE;
  prf.righttitle = PREFS_DEFAULT_RIGHTTITLE;

  prf.trigunit = PREFS_DEFAULT_TRIGUNIT;
  prf.calcmode = PREFS_DEFAULT_CALCMODE;
}


int prefs_save(void)
{
   FILE *fp;
   /*int i;*/

	char	* pconfig = get_config_path();

   fp = fopen( pconfig , "w");
   if (fp == NULL)
     {
	free( pconfig );
	/*ERROR*/
       return 0;
     }
   
   fprintf(fp, "%c This is the GtkGraph initialization file.\n", comment);
   fprintf(fp, "%c Lines that start with a '%c' are comments.\n", comment, comment);
   fprintf(fp, "%c Blank lines are ignored.\n\n", comment);
   
   fprintf(fp, "%c Set the color information for the plots\n", comment);
   /*fprintf(fp, "color %x:%x:%x %x:%x:%x %x:%x:%x %x:%x:%x %x:%x:%x %x:%x:%x %x:%x:%x %x:%x:%x %x:%x:%x %x:%x:%x\n",                    prf.color[0].red,
	                                                prf.color[0].green,
                                                        prf.color[0].blue,
                                                        prf.color[1].red,
	                                                prf.color[1].green,
                                                        prf.color[1].blue,
	                                                prf.color[2].red,
	                                                prf.color[2].green,
                                                        prf.color[2].blue,
                                                        prf.color[3].red,
	                                                prf.color[3].green,
                                                        prf.color[3].blue,
                                                        prf.color[4].red,
	                                                prf.color[4].green,
                                                        prf.color[4].blue,
                                                        prf.color[5].red,
	                                                prf.color[5].green,
                                                        prf.color[5].blue,
                                                        prf.color[6].red,
	                                                prf.color[6].green,
                                                        prf.color[6].blue,
                                                        prf.color[7].red,
	                                                prf.color[7].green,
                                                        prf.color[7].blue,
                                                        prf.color[8].red,
	                                                prf.color[8].green,
                                                        prf.color[8].blue,
                                                        prf.color[9].red,
	                                                prf.color[9].green,
                                                        prf.color[9].blue     );*/
   /* Don't save colors anymore */

   /*for (i=0; i != MAX_FUNC; ++i)
   {
       fprintf(fp, " %x:%x:%x", prf.color[i].red, prf.color[i].green, prf.color[i].blue);
   }
   fprintf (fp, "\n");*/

   fprintf (fp, "axescolor %x:%x:%x\n", prf.axiscolor.red, prf.axiscolor.green, prf.axiscolor.blue);
   fprintf (fp, "gridcolor %x:%x:%x\n", prf.gridcolor.red, prf.gridcolor.green, prf.gridcolor.blue);
   fprintf (fp, "backcolor %x:%x:%x\n", prf.bgcolor.red, prf.bgcolor.green, prf.bgcolor.blue);

   fprintf (fp, "legend %i\n", prf.showlegend);
   fprintf (fp, "showtitle %i %c %s\n", prf.toptitle, comment, _("Show plot title?"));
   fprintf (fp, "showx %i %c %s\n", prf.bottomtitle, comment, _("Show X axis title?"));
   fprintf (fp, "showy %i %c %s\n", prf.lefttitle, comment, _("Show Y axis title?"));
   
   if (prf.trigunit == MP_UNIT_RADIAN)
     {
       fprintf (fp, "trigunit %s\n", "radians");
     }
   else
     {
       fprintf (fp, "trigunit %s\n", "degrees");
     }


   if (prf.calcmode == CALCMODE_SELECT)
     {
	fprintf (fp, "calcmode %s\n", "select");
     }
   else if (prf.calcmode == CALCMODE_APPEND)
     {
	fprintf (fp, "calcmode %s\n", "append");
     }
   else if (prf.calcmode == CALCMODE_CLEAR)
     {
	fprintf (fp, "calcmode %s\n", "clear");
     }

   fprintf (fp, "append_on_err %i\n", prf.errappend);

   fprintf (fp, "hgrid %i\n", prf.showhgrid);
   fprintf (fp, "vgrid %i\n", prf.showvgrid);

   fprintf (fp, "%c End of GtkGraph initialization file.\n", comment);

   fclose(fp);

   chmod( pconfig , 00600);
	free( pconfig );

   return (1);
}


int prefs_read(void)
{
   FILE *fp;
   gchar buffer[256];
   /*int i, colornum=0, channum=0;*/
   

	char	* pconfig = get_config_path();

   fp = fopen( pconfig , "r");
/* fp = fopen(get_config_path(), "r");	*/
   if (fp == NULL)
     {
	 /*ERROR*/
	free( pconfig );
       return 0;
     }

   while (!feof(fp))
   {
       fgets(buffer, 256, fp);
       trim_leadspc(buffer);
       if (buffer[0] != eoln && buffer[0] != comment)
       {
	   /* now we know to parse for variables */
#if 0
	   if (!strncmp("color", buffer, strlen("color")))
	   {
	       remove_string(buffer, 0, strlen("color"));
	       
	       for (i=0; buffer[i] != 0; ++i)
	       {
		   if (buffer[i] == ' ' || buffer[i] == ':')
		   {
		       if (channum == 0)
		       {
			   gdk_colormap_free_colors (gdk_colormap_get_system(), &prf.color[colornum], 1);
		       }
		       buffer[i] = ' ';

		       switch (channum)
		       {
		       case 0:
			   prf.color[colornum].red = strtol (&buffer[i], (char **)NULL, 16);
			   break;
		       case 1:
			   prf.color[colornum].green = strtol (&buffer[i], (char **)NULL, 16);
			   break;
		       case 2:
			   prf.color[colornum].blue = strtol (&buffer[i], (char **)NULL, 16);
			   break;
		       }
		       
		       if (channum == 2)
		       {
			   channum = 0;
			   gdk_color_alloc(gdk_colormap_get_system(), &prf.color[colornum]);
			   gtk_plot_dataset_set_line_attributes(dataset[colornum],
								GTK_PLOT_LINE_SOLID,
								0, prf.color[colornum]);
			   /*gdk_color_change (gdk_colormap_get_system(), &prf.color[colornum]);*/
			   ++colornum;
		       }
		       else              { ++channum;               }
		   }
	       }
	   }
#endif
	   if (!strncmp("axescolor", buffer, strlen("axescolor")))
	   {
	       unsigned int r, g, b;
	       
	       remove_string(buffer, 0, strlen("axescolor"));
	       trim_leadspc (buffer);
	       
	       gdk_colormap_free_colors (gdk_colormap_get_system(), &prf.axiscolor, 1);
	       
	       sscanf (buffer, "%x:%x:%x", &r, &g, &b);
	       
	       prf.axiscolor.red = r;
	       prf.axiscolor.green = g;
	       prf.axiscolor.blue = b;
	       
	       gdk_color_alloc(gdk_colormap_get_system(), &prf.axiscolor);
	   }
	   
	   if (!strncmp("gridcolor", buffer, strlen("gridcolor")))
	   {
	       unsigned int r, g, b;
	       
	       remove_string(buffer, 0, strlen("gridcolor"));
	       trim_leadspc (buffer);
	       
	       gdk_colormap_free_colors (gdk_colormap_get_system(), &prf.gridcolor, 1);
	       
	       sscanf (buffer, "%x:%x:%x", &r, &g, &b);
	       
	       prf.gridcolor.red = r;
	       prf.gridcolor.green = g;
	       prf.gridcolor.blue = b;
	       
	       gdk_color_alloc(gdk_colormap_get_system(), &prf.gridcolor);
	   }

	   if (!strncmp("backcolor", buffer, strlen("backcolor")))
	   {
	       unsigned int r, g, b;
	       
	       remove_string(buffer, 0, strlen("backcolor"));
	       trim_leadspc (buffer);
	       
	       gdk_colormap_free_colors (gdk_colormap_get_system(), &prf.bgcolor, 1);
	       
	       sscanf (buffer, "%x:%x:%x", &r, &g, &b);
	       
	       prf.bgcolor.red = r;
	       prf.bgcolor.green = g;
	       prf.bgcolor.blue = b;
	       
	       gdk_color_alloc(gdk_colormap_get_system(), &prf.bgcolor);
	   }
	   
	   else if (!strncmp("legend", buffer, strlen("legend")))
	   {
	       remove_string(buffer, 0, strlen("legend"));
	       trim_leadspc (buffer);
	       if (buffer[0] == '1')
		   prf.showlegend = 1;
	       else if (buffer[0] == '0')
		   prf.showlegend = 0;
	       else
		   return (0);
	   }
	   else if (!strncmp("showtitle", buffer, strlen("showtitle")))
	   {
	       remove_string(buffer, 0, strlen("showtitle"));
	       trim_leadspc (buffer);
	       if (buffer[0] == '1')
		   prf.toptitle = 1;
	       else if (buffer[0] == '0')
		   prf.toptitle = 0;
	       else
		   return (0);
	   }
	   else if (!strncmp("showx", buffer, strlen("showx")))
	     {
		 remove_string(buffer, 0, strlen("showx"));
		 trim_leadspc (buffer);
		 if (buffer[0] == '1')
		     prf.bottomtitle = 1;
		 else if (buffer[0] == '0')
		     prf.bottomtitle = 0;
		 else
		     return (0);
	     }
	   else if (!strncmp("showy", buffer, strlen("showy")))
	   {
	       remove_string(buffer, 0, strlen("showy"));
	       trim_leadspc (buffer);
	       if (buffer[0] == '1')
		   prf.lefttitle = 1;
	       else if (buffer[0] == '0')
		   prf.lefttitle = 0;
	       else
		   return (0);
	   }
	   else if (!strncmp("trigunit", buffer, strlen("trigunit")))
	   {
	       remove_string(buffer, 0, strlen("trigunit"));
	       trim_leadspc (buffer);
	       if (!strncmp ("radians", buffer, strlen("radians")))
	       {
		   prf.trigunit = MP_UNIT_RADIAN;
	       }
	       else if (!strncmp ("degrees", buffer, strlen("degrees")))
	       {
		   prf.trigunit = MP_UNIT_DEGREE;
	       }
	       else
	       {
		   return (0);
	       }
	     }
	   
	   else if (!strncmp("calcmode", buffer, strlen("calcmode")))
	   {
	       remove_string(buffer, 0, strlen("calcmode"));
       	       trim_leadspc (buffer);
               if (!strncmp ("select", buffer, strlen("select")))
               {
		   prf.calcmode = CALCMODE_SELECT;
               }
               else if (!strncmp ("append", buffer, strlen("append")))
               {
		   prf.calcmode = CALCMODE_APPEND;
               }
	       else if (!strncmp ("clear", buffer, strlen("clea")))
               {
		   prf.calcmode = CALCMODE_CLEAR;
               }
               else
	       {
                   return (0);
	       }
	   }
	   
	   else if (!strncmp("append_on_err", buffer, strlen("append_on_err")))
	   {
               remove_string(buffer, 0, strlen("append_on_err"));
               trim_leadspc (buffer);
               if (buffer[0] == '1')
		   prf.errappend = 1;
               else if (buffer[0] == '0')
		   prf.errappend = 0;
               else
		   return (0);
	   }
	   else if (!strncmp("vgrid", buffer, strlen("vgrid")))
	   {
               remove_string(buffer, 0, strlen("vgrid"));
               trim_leadspc (buffer);
               if (buffer[0] == '1')
		   prf.showvgrid = 1;
               else if (buffer[0] == '0')
		   prf.showvgrid = 0;
               else
		   return (0);
	   } 
	   else if (!strncmp("hgrid", buffer, strlen("hgrid")))
	   {
               remove_string(buffer, 0, strlen("hgrid"));
               trim_leadspc (buffer);
               if (buffer[0] == '1')
		   prf.showhgrid = 1;
               else if (buffer[0] == '0')
		   prf.showhgrid = 0;
               else
		   return (0);
	   }
	 }
     }
   free(pconfig);
   return 1;
}


static char *get_config_path()
{
  char *home_dir;
  unsigned int home_dir_len;
  char *buffer;
  home_dir_len = strlen(getenv("HOME"));
  home_dir = malloc(home_dir_len + 1);
  strcpy(home_dir, getenv("HOME"));
  buffer = malloc(home_dir_len + 1 + strlen("/.gtkgraphrc") + 1);
  sprintf(buffer, "%s/%s", home_dir, "/.gtkgraphrc");
  free(home_dir);
  return buffer;
}


/* This gets called when we reset prefs or initialize them. It makes the pref changes take effect on the current widgets. */
void reset_flags (void)
{
    gtk_plot_set_background (GTK_PLOT(active_plot), prf.bgcolor);
    
    gtk_plot_major_vgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    gtk_plot_major_hgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    gtk_plot_minor_vgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    gtk_plot_minor_hgrid_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_DOTTED, 1, prf.gridcolor);
    
    gtk_plot_axis_set_visible (GTK_PLOT(active_plot), GTK_PLOT_AXIS_TOP, prf.showtop);
    gtk_plot_axis_set_visible (GTK_PLOT(active_plot), GTK_PLOT_AXIS_RIGHT, prf.showright);
    gtk_plot_axis_set_visible (GTK_PLOT(active_plot), GTK_PLOT_AXIS_LEFT, prf.showleft);
    gtk_plot_axis_set_visible (GTK_PLOT(active_plot), GTK_PLOT_AXIS_BOTTOM, prf.showbottom);
    if (prf.toptitle)
    {
	gtk_plot_axis_show_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_TOP);
    }
    else
    {
	gtk_plot_axis_hide_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_TOP);
    }
    if (prf.righttitle)
    {
	gtk_plot_axis_show_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_RIGHT);
    }
    else
    {
	gtk_plot_axis_hide_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_RIGHT);
    }
    if (prf.lefttitle)
    {
       gtk_plot_axis_show_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_LEFT);
    }
    else
    {
       gtk_plot_axis_hide_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_LEFT);
    }
    if (prf.bottomtitle)
    {
	gtk_plot_axis_show_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_BOTTOM);
    }
    else
    {
	gtk_plot_axis_hide_title (GTK_PLOT(active_plot), GTK_PLOT_AXIS_BOTTOM);
    }
    
    gtk_plot_x0_set_visible (GTK_PLOT(active_plot), prf.showxy);
    gtk_plot_y0_set_visible (GTK_PLOT(active_plot), prf.showxy);

    gtk_plot_grids_set_visible (GTK_PLOT(active_plot), prf.showvgrid, prf.showvgrid, prf.showhgrid, prf.showhgrid);
 
    if (prf.showlegend)
    {
	gtk_plot_show_legends (GTK_PLOT(active_plot));
    }
    else
    {
	gtk_plot_hide_legends (GTK_PLOT(active_plot));
    }

    gtk_plot_x0line_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_SOLID, 1, prf.axiscolor);
    gtk_plot_y0line_set_attributes (GTK_PLOT(active_plot), GTK_PLOT_LINE_SOLID, 1, prf.axiscolor);
    
    gtk_widget_queue_draw (layout);
}


