/* Copyright (C) 1999 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <string.h>
#include <stdlib.h>
#include <limits.h>

#include <gtk/gtk.h>

#include "gtkplot.h"
#include "gtksheet.h"

#include "app.h"
#include "function.h"
#include "mathparsesym.h"
#include "mathparse.h"
#include "callbacks.h"
#include "dialogs.h"


extern gint nbrfuncs, nbrrealfuncs;
gint nbrfuncs_ever=0;
extern func_thing **funcs;
extern GtkWidget *menu, *menu_item, *opmenu;
extern GtkWidget *active_plot;
extern func_thing *formn, *currform;
extern GtkWidget *edit;
extern struct mp_stack **entryidx[2][2];

extern void set_error (void);


static char * default_colors [] = { "blue",
                                    "red",
                                    "turquoise",
                                    "green",
                                    "yellow",
                                    "brown",
                                    "orange",
                                    "magenta",
                                    "purple",
                                    "HotPink1" };


/* We see aaron's creative naming conventions in full force here. has only been beaten by structure called 'thing' */
gdouble function_function (GtkPlot *plot, GtkPlotData *dataset, gdouble x, gboolean *err)
{
    extern struct mp_stack **entryidx[2][2];
    gdouble result=0;
    func_thing *funky_thing = (func_thing *) dataset->data;
    
    if (funky_thing->eqnflag)
    {
	entryidx[0][0] = &funky_thing->entryidx[0][0];
	entryidx[0][1] = &funky_thing->entryidx[0][1];
	entryidx[1][0] = &funky_thing->entryidx[1][0];
	entryidx[1][1] = &funky_thing->entryidx[1][1];
	formn = funky_thing;

	*err = FALSE;
	result = mp_eval_exp (x, err);
	mp_fix_stack ();
	if (*err)
	{
	    set_error();
	    gtk_plot_hide_dataset (funky_thing->real_dataset);	
	}
    }
    else
    {
	*err = TRUE;
	result = 0;
    }
    return (result);
}


func_thing * new_function (void)
{
    char name [20];
    GdkColor color;
    func_thing *function=0;
    int i;
    
    /* Try to find an unused function */
    for (i=0; i != nbrfuncs; ++i)
    {
	if (!funcs[i]->usable)
	{
	    function = funcs[i];
	}
    }
    
    if (!function)
    {
	funcs = (func_thing **) realloc (funcs, (++nbrfuncs)*sizeof(func_thing *));
	funcs[nbrfuncs-1] = malloc (sizeof(func_thing));
	function = funcs[nbrfuncs-1];
    }
    
    
    
    ++nbrrealfuncs;
    ++nbrfuncs_ever;
   
    /* Allocated, now null it out woohoo */

    strcpy (name, _("Untitled Function"));

    /* Is this an active, visible equation? */
    function->eqnflag = 0;
    /* The text of the function */
    function->formc = 0;
    /* Calculation stack linked list */
    function->entryidx[0][0]=0;
    function->entryidx[0][1]=0;
    function->entryidx[1][0]=0;
    function->entryidx[1][1]=0;
    /* Index in popup */
    function->index = nbrfuncs-1;
    /* Usable */
    function->usable = TRUE;
    /* Name of function */
    function->name = malloc ((strlen(name)+1)*sizeof(char));
    strcpy (function->name, name);
    /* Error string */
    function->error = 0;
    
    function->real_dataset = gtk_plot_add_function(GTK_PLOT(active_plot), function_function);
    function->real_dataset->data = (gpointer) function;
    
    gdk_color_parse(default_colors[(nbrfuncs_ever-1)%10], &color); /* Reuse the colors */
    gdk_color_alloc(gdk_colormap_get_system(), &color);
    
    gtk_plot_dataset_set_line_attributes(function->real_dataset,
					 GTK_PLOT_LINE_SOLID,
					 0, color);
    
    
    gtk_plot_dataset_set_legend(function->real_dataset, name);
    gtk_plot_hide_dataset (function->real_dataset); /* Hahah!! */
    
    function->menu_item = gtk_menu_item_new ();
    function->label = gtk_label_new (name);
    gtk_widget_show (function->label);
    gtk_container_add (GTK_CONTAINER(function->menu_item), function->label);
    gtk_misc_set_alignment (GTK_MISC(function->label), 0, 0);
    gtk_menu_insert (GTK_MENU(menu), function->menu_item, nbrrealfuncs-1); /* Insert it after all the other functions but before the add/delete items */

    /*++items_in_menu;*/

    gtk_signal_connect (GTK_OBJECT(function->menu_item), "activate", GTK_SIGNAL_FUNC (callback_popup), (gpointer)function);
    gtk_widget_show (function->menu_item);
    
    return (function);
}

void new_function_menu (GtkWidget *w, gpointer data)
{
    func_thing *newfunc = new_function();
    gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), newfunc->index);
    callback_popup (GTK_WIDGET(funcs[nbrfuncs-1]->menu_item), (gpointer)newfunc);
}

void del_function (GtkWidget *w, gpointer data)
{
    int i;
    signed long dist=LONG_MAX;
    func_thing *function=currform, *new_sel=0;


    if (nbrrealfuncs == 1) /* Last function, don't delete for now */
    {
	/* Setting history */
	gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), function->index);
	return;
    }

    gtk_widget_destroy (function->menu_item);
    
    for (i=0; i != nbrfuncs; ++i)
    {
	/* Adjust indexes to be correct now that this function has been removed */
	if (funcs[i]->index > function->index)
	{
	    /* This came after the function we are deleting, it will need correction */
	    --(funcs[i]->index);
	}
    }


    /* Set usable flag here so callback_popup knows that this function has been deleted */
    /* Also do it so that it doesn't find itself as the closest function */
    /* Finding itself, heh that would be cool, maybe in C++ */
    /* Here it would be del_function finding it :( */

    /* Usable */
    function->usable = FALSE;

    for (i=0; i != nbrfuncs; ++i)
    {
	/* Find the closest function */
	if (funcs[i]->usable && abs(funcs[i]->index - function->index) < dist)
	{
	    new_sel = funcs[i];
	    dist = abs(funcs[i]->index - function->index);
	}
    }


    if (!new_sel)
    {
	/* Last function is being deleted... can it handle this? */
	/*gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), 0);
	gtk_entry_set_text (GTK_ENTRY(edit), "");
	currform = NULL;*/

	/* Look, if there were no other functions, the func didn't change anything
	   It can still bail out */
	return;
    }
    else
    {
	/* Setting history */
	gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), new_sel->index);
	callback_popup (GTK_WIDGET(new_sel->menu_item), (gpointer)new_sel);
    }
    
    --nbrrealfuncs;

    /* Is this an active, visible equation? */
    function->eqnflag = 0;
    /* The text of the function */
    if (function->formc)
    { /* free equation if this function has one */
	free (function->formc);
    }
    function->formc = 0;
    /* Calculation stack linked list */
    entryidx[0][0] = &function->entryidx[0][0];
    entryidx[0][1] = &function->entryidx[0][1];
    entryidx[1][0] = &function->entryidx[1][0];
    entryidx[1][1] = &function->entryidx[1][1];
    mp_stack_clean ();
    function->entryidx[0][0]=0;
    function->entryidx[0][1]=0;
    function->entryidx[1][0]=0;
    function->entryidx[1][1]=0;
    /* Index in popup */
    function->index = -1; /* It's no longer in the popup */
    /* Free dataset */
    gtk_plot_remove_dataset (GTK_PLOT(active_plot), function->real_dataset);
    /*free (function->real_dataset);*/
    function->real_dataset = 0;
    /* Name of function */
    if (function->name) /* Should always be true */
    {
	free (function->name);
    }
    function->name = 0;
    /* Error string */
    if (function->error)
	free (function->error);
    function->error = 0;

    gtk_widget_queue_draw (active_plot);

    /*--items_in_menu;*/
}


void chname_function (GtkWidget *w, gpointer data)
{
    gtk_option_menu_set_history (GTK_OPTION_MENU(opmenu), currform->index);
    dialog_rename (currform, 0 /* 0 == function */);
}
