/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "appearance.h"
#include "handleP.h"

int
ApStreamIn(Pool *p, Handle **hp, Appearance **app)
{ 
  if(hp) *hp = NULL;
  if(app) *app = ApFLoad( *app, p->inf, "stream" );
  if (*app == NULL) return 0;
  return 1;
}

int
ApStreamOut(Pool *p, Handle *h, Appearance *ap)
{
    if(p == NULL || p->type != P_STREAM || p->outf == NULL)
	return 0;

    ApFSave(ap, h, p->outf, p->poolname);
    return 1;
}
