#include "mgP.h"
#include "mgx11P.h"

int mgx11_getvisual( Display *dpy, Visual **mgvis,
				Colormap *mgcol, int *mgdepth)
{
  static XVisualInfo vTemplate;
  static XVisualInfo *visualList;
  unsigned int nplanes = 0;
  unsigned long planemasks[1];
  unsigned long testcols[30];
  int	      mgpriv = 0;
  int         visualsMatched;


  vTemplate.screen = DefaultScreen(dpy);
  vTemplate.class = TrueColor;
  *mgdepth = vTemplate.depth = 24;
  visualList = XGetVisualInfo(dpy, VisualScreenMask | VisualClassMask |
                              VisualDepthMask, &vTemplate, &visualsMatched);
  if (visualsMatched == 0)
  {
	*mgdepth = vTemplate.depth = 16;
	visualList = XGetVisualInfo(dpy, VisualScreenMask | VisualClassMask |
				 VisualDepthMask, &vTemplate, &visualsMatched);
  }

  if (visualsMatched == 0) {
	vTemplate.depth = 15;  /* But leave mgdepth == 16 (2-byte data) */
        visualList = XGetVisualInfo(dpy, VisualScreenMask | VisualClassMask |
				 VisualDepthMask, &vTemplate, &visualsMatched);
  }
  if (visualsMatched == 0) {
	vTemplate.depth = 12;  /* Ditto, leave mgdepth == 16 for 2-byte data */
        visualList = XGetVisualInfo(dpy, VisualScreenMask | VisualClassMask |
				 VisualDepthMask, &vTemplate, &visualsMatched);
  }
  if (visualsMatched == 0)
  {
	vTemplate.class = PseudoColor;
	*mgdepth = vTemplate.depth = 8;
	visualList = XGetVisualInfo(dpy, VisualScreenMask | VisualClassMask |
			     VisualDepthMask, &vTemplate, &visualsMatched);
  }
  if (visualsMatched == 0)
  {
	 *mgdepth = vTemplate.depth = 1;
	 visualList = XGetVisualInfo(dpy, VisualScreenMask | VisualDepthMask,
					  &vTemplate, &visualsMatched);
  }
  if (visualsMatched == 0)
    return MG_X11VISFAIL; /* Didn't find a useful visual! */

  *mgvis = visualList[0].visual;

  if (*mgdepth == 8)
  {
    if (!XAllocColorCells(dpy,
		DefaultColormapOfScreen(DefaultScreenOfDisplay(dpy)),
		False, planemasks, nplanes, testcols, (unsigned int)30))
      /* there aren't enough colors so use private colormap instead */
      mgpriv = 1;
    else
    {
      /* there *are* enough colors in shared colormap */
      mgpriv = 0;
      XFreeColors(dpy, DefaultColormapOfScreen(DefaultScreenOfDisplay(dpy)),
		testcols, 30, nplanes);
    }
  }

  

  if (*mgdepth == 16 || *mgdepth == 24)
  {
    *mgcol = XCreateColormap(dpy, RootWindow(dpy, DefaultScreen(dpy)),
                                *mgvis, AllocNone);
  }
  else
    if (*mgdepth == 1)
      *mgcol = DefaultColormapOfScreen(DefaultScreenOfDisplay(dpy));
    else
      if (*mgdepth == 8) {
        if (!mgpriv)
          *mgcol = DefaultColormapOfScreen(DefaultScreenOfDisplay(dpy));
        else
          *mgcol = XCreateColormap(dpy,
                RootWindow(dpy, DefaultScreen(dpy)), *mgvis, AllocNone);
      }

  if (mgpriv)
    return MG_X11VISPRIVATE;
  else
    return MG_X11VISSUCCEED;

}

/*****************************************************************************/
