#include <stdio.h>
#include "vec4.h" 
#include "dgflag.h"
#include "math.h"

double 
DHPt3Dot(point4 v0, point4 v1, int metric)
{
    switch (metric)	{
	case DG_EUCLIDEAN:
	    return(v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2] + v0[3]*v1[3]);
	    break;
	case DG_HYPERBOLIC:
	    return(v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2] - v0[3]*v1[3]);
	    break;
	case DG_SPHERICAL:
	    return(v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2] + v0[3]*v1[3]);
	    break;
	}
}

double 
DHPt3Dot3(point4 v0, point4 v1, int metric)
{
    switch (metric)	{
	case DG_EUCLIDEAN:
	    return(v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2]);
	    break;
	case DG_HYPERBOLIC:
	    return(v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2] - v0[3]*v1[3]);
	    break;
	case DG_SPHERICAL:
	    return(v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2] + v0[3]*v1[3]);
	    break;
	}
}

double
DHPt3Distance(point4 p0, point4 p1, int metric)
{
	double d0, d1;
	point4 diff;
    switch (metric)	{
	case DG_EUCLIDEAN:
	    VSUB3(p0,p1, diff);
	    return(MAGNITUDE3(diff));
	    break;
	case DG_HYPERBOLIC:
	    d0 =INPRO31(p0, p0);
	    d1 =INPRO31(p1, p1);
	    if (d0 >= 0.0 || d1 >= 0.0)	{
		fprintf(stderr,"Invalid points in dist_proj3\n");
		return(0.0);
		}
	    return(acosh( ABS( INPRO31(p0, p1) / sqrt(d0 * d1))));
	    break;
	case DG_SPHERICAL:
	    d0 =INPRO31(p0, p0);
	    d1 =INPRO31(p1, p1);
	    return(acos( ABS( INPRO4(p0, p1) / sqrt(d0 * d1))));
	    break;

	}
}

void
DHPt3PerpBisect(point4 p0, point4 p1, point4 result, int metric)
{
    switch (metric)	{
      case  DG_EUCLIDEAN:
	{
	point4 tmp;
	double t;
	VSUB3(p1, p0, result)
	VADD3(p0, p1, tmp)
	VSCALE3(tmp, .5, tmp)
	result[3] = -(VDOT3(tmp, result));
	}
	break;

      case DG_HYPERBOLIC:
	NORMALIZE31(p0);
	NORMALIZE31(p1);
	VSUB4(p0, p1, result)
	if (INPRO31(p0, result) > 0.0)	VSCALE4(result, -1, result)
	break;

      case DG_SPHERICAL:
	NORMALIZE4(p0);
	NORMALIZE4(p1);
	VSUB4(p0, p1, result)
	if (INPRO4(p0, result) > 0.0)	VSCALE4(result, -1, result)
	break;

    }
}
	
	
    
