/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"

#define	BB_MIN(a,b)	( (a) <= (b) ? a : b )
#define	BB_MAX(a,b)	( (a) >= (b) ? a : b )

BBox *
BBoxUnion(BBox *bbox1, BBox *bbox2)
{
    return BBoxUnion3(bbox1, bbox2, NULL);
}

BBox *
BBoxUnion3(register BBox *bbox1, register BBox *bbox2, register BBox *result)
{
	HPoint3	min, max;


	/* TAKE CARE OF THE CASE OF EITHER CUBE BEING NULL */
	if (!bbox1) {
	    if(!bbox2) {
		if(result) {
		    static Point Max = { -1e10,-1e10,-1e10, 1 };
		    static Point Min = {  1e10, 1e10, 1e10, 1 };
		    result->min = Min;
		    result->max = Max;
		}
		return result;
	    }
	    bbox1 = bbox2;
	    bbox2 = NULL;
	}
	min = bbox1->min;
	max = bbox1->max;
	if(bbox2) {
	    if(min.x > bbox2->min.x) min.x = bbox2->min.x;
	    if(max.x < bbox2->max.x) max.x = bbox2->max.x;
	    if(min.y > bbox2->min.y) min.y = bbox2->min.y;
	    if(max.y < bbox2->max.y) max.y = bbox2->max.y;
	    if(min.z > bbox2->min.z) min.z = bbox2->min.z;
	    if(max.z < bbox2->max.z) max.z = bbox2->max.z;
	}
	/* this needs to be fleshed out for true 4D */
	min.w = max.w = 1.0;
	if(result == NULL)
	    return (BBox *)GeomCCreate(NULL, BBoxMethods(),
				CR_MIN, &min, CR_MAX, &max, CR_END);
	result->min = min;
	result->max = max;
	return result;
}
