#include "fexpr.h"
#include <stdlib.h>

expr_var expr_create_variable(struct expression *e, char *name, double val)
{
  int i;

  if (e->varnames)
    for (i=0; i<e->nvars; i++)
      if (!strcmp(e->varnames[i], name)) {
	e->varvals[i].real = val;
	return i;
      }
  
  if (e->nvars) {
    e->varnames = realloc(e->varnames, (1+e->nvars)*sizeof(char *));
    e->varvals = realloc (e->varvals, (1+e->nvars)*sizeof(fcomplex));
  } else {
    e->varnames = malloc ((e->nvars+1)*sizeof(char *));
    e->varvals = malloc ((e->nvars+1) * sizeof(fcomplex));
  }
  e->varnames[e->nvars] = malloc(strlen(name)+1);
  strcpy (e->varnames[e->nvars],name);
  e->varvals[e->nvars].real = val;
  e->varvals[e->nvars].imag = 0;
  
  return e->nvars++;
}

void expr_set_variable(struct expression *e, expr_var v, double val)
{
  e->varvals[v].real = val;
}

double expr_get_variable(struct expression *e, expr_var v)
{
  return e->varvals[v].real;
}
void expr_set_variable_complex(struct expression *e, expr_var v, fcomplex*val)
{
  e->varvals[v] = *val;
}

void expr_get_variable_complex(struct expression *e, expr_var v,fcomplex *op)
{
  *op = e->varvals[v];
}

