/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "color.h"

void
PaintOver( f, b, t, m )
    register ColorA *f, *b, *t;
    register float *m;
{
    register float a = 1.0 - *m * f->a;

    t->r = *m * f->r + a * b->r;
    t->g = *m * f->g + a * b->g;
    t->b = *m * f->b + a * b->b;
    t->a = *m * f->a + a * b->a;
}

void
PaintOverN( f, b, t, m, n )
    register ColorA *f, *b, *t;
    register float *m;
    register int n;
{
    register float a;
    
    while( n-- ) {
	a = 1.0 - *m * f->a;
	t->r = *m * f->r + a * b->r;
	t->g = *m * f->g + a * b->g;
	t->b = *m * f->b + a * b->b;
	t->a = *m * f->a + a * b->a;
	f++;
	b++;
	t++;
	m++;
    }
}
