/* $Id$ */

#define F_RF(funcname) extern double funcname(int, double *, void *)
#define F_CF(funcname) extern void funcname(int, fcomplex *,fcomplex *, void *)
#define F_DF(funcname) extern void funcname(int, fjet *, fjet *, void *)
/* constants */

F_RF(fr_const);
F_CF(fc_rconst);
F_CF(fc_cconst);
F_DF(fd_const);

F_RF(fr_var);
F_CF(fc_var);
F_DF(fd_var);

/* basic real functions */

F_RF(fr_add);
F_RF(fr_sub);
F_RF(fr_mul);
F_RF(fr_div);
F_RF(fr_id);
F_RF(fr_neg);

/* basic complex functions */

F_CF(fc_add);
F_CF(fc_sub);
F_CF(fc_mul);
F_CF(fc_div);
F_CF(fc_id);
F_CF(fc_neg);

/* more real functions */

F_RF(fr_abs);
F_RF(fr_exp);
F_RF(fr_log);
F_RF(fr_log10);
F_RF(fr_erf);
F_RF(fr_sqrt);
F_RF(fr_sin);
F_RF(fr_arcsin);
F_RF(fr_arcsin);
F_RF(fr_arcsin);
F_RF(fr_cos);
F_RF(fr_arccos);
F_RF(fr_arccos);
F_RF(fr_arccos);
F_RF(fr_tan);
F_RF(fr_arctan);
F_RF(fr_arctan);
F_RF(fr_arctan);
F_RF(fr_arctan2);
F_RF(fr_arctan2);
F_RF(fr_arctan2);
F_RF(fr_arctan2);
F_RF(fr_arctan2);
F_RF(fr_arctan2);
F_RF(fr_sinh);
F_RF(fr_arcsinh);
F_RF(fr_arcsinh);
F_RF(fr_cosh);
F_RF(fr_arccosh);
F_RF(fr_arccosh);
F_RF(fr_tanh);
F_RF(fr_arctanh);
F_RF(fr_arctanh);
F_RF(fr_floor);
F_RF(fr_floor);
F_RF(fr_round);
F_RF(fr_ceil);
F_RF(fr_pow);
F_RF(fr_re);
F_RF(fr_im);
F_RF(fr_cot);
F_RF(fr_sec);
F_RF(fr_csc);

/* more complex functions */
F_CF(fc_abs);
F_CF(fc_exp);
F_CF(fc_log);
F_CF(fc_log10);
F_CF(fc_sqrt);
F_CF(fc_sin);
F_CF(fc_arcsin);
F_CF(fc_arcsin);
F_CF(fc_arcsin);
F_CF(fc_cos);
F_CF(fc_arccos);
F_CF(fc_arccos);
F_CF(fc_arccos);
F_CF(fc_tan);
F_CF(fc_arctan);
F_CF(fc_arctan);
F_CF(fc_arctan);
F_CF(fc_arctan2);
F_CF(fc_arctan2);
F_CF(fc_arctan2);
F_CF(fc_arctan2);
F_CF(fc_arctan2);
F_CF(fc_arctan2);
F_CF(fc_sinh);
F_CF(fc_arcsinh);
F_CF(fc_arcsinh);
F_CF(fc_cosh);
F_CF(fc_arccosh);
F_CF(fc_arccosh);
F_CF(fc_tanh);
F_CF(fc_arctanh);
F_CF(fc_arctanh);
F_CF(fc_floor);
F_CF(fc_floor);
F_CF(fc_round);
F_CF(fc_ceil);
F_CF(fc_pow);
F_CF(fc_re);
F_CF(fc_im);
F_CF(fc_cot);
F_CF(fc_sec);
F_CF(fc_csc);

/* deriv functions */

F_DF(fd_approx);		/* generic numerical derivitive */

/*F_DF(fd_add);
F_DF(fd_sub);*/
F_DF(fd_mul);
F_DF(fd_neg);
F_DF(fd_sin);
F_DF(fd_cos);
F_DF(fd_pow);
F_DF(fd_id);
F_DF(fd_linear);
F_DF(fd_sinh);
F_DF(fd_cosh);

/* ff_* stuff */
extern struct ffuncstruct ff_add;
extern struct ffuncstruct ff_sub;
extern struct ffuncstruct ff_mul;
extern struct ffuncstruct ff_div;
extern struct ffuncstruct ff_id;
extern struct ffuncstruct ff_neg;
extern struct ffuncstruct ff_abs;
extern struct ffuncstruct ff_exp;
extern struct ffuncstruct ff_log;
extern struct ffuncstruct ff_log10;
extern struct ffuncstruct ff_erf;
extern struct ffuncstruct ff_sqrt;
extern struct ffuncstruct ff_sin;
extern struct ffuncstruct ff_asin;
extern struct ffuncstruct ff_arcsin;
extern struct ffuncstruct ff_invsin;
extern struct ffuncstruct ff_cos;
extern struct ffuncstruct ff_acos;
extern struct ffuncstruct ff_arccos;
extern struct ffuncstruct ff_invcos;
extern struct ffuncstruct ff_tan;
extern struct ffuncstruct ff_atan;
extern struct ffuncstruct ff_arctan;
extern struct ffuncstruct ff_invtan;
extern struct ffuncstruct ff_atan2;
extern struct ffuncstruct ff_arctan2;
extern struct ffuncstruct ff_invtan2;
extern struct ffuncstruct ff_sinh;
extern struct ffuncstruct ff_arcsinh;
extern struct ffuncstruct ff_invsinh;
extern struct ffuncstruct ff_cosh;
extern struct ffuncstruct ff_arccosh;
extern struct ffuncstruct ff_invcosh;
extern struct ffuncstruct ff_tanh;
extern struct ffuncstruct ff_arctanh;
extern struct ffuncstruct ff_invtanh;
extern struct ffuncstruct ff_int;
extern struct ffuncstruct ff_floor;
extern struct ffuncstruct ff_round;
extern struct ffuncstruct ff_ceil;
extern struct ffuncstruct ff_ceiling;
extern struct ffuncstruct ff_pow;
extern struct ffuncstruct ff_re;
extern struct ffuncstruct ff_im;
extern struct ffuncstruct ff_cot;
extern struct ffuncstruct ff_sec;
extern struct ffuncstruct ff_csc;

extern struct ffuncstruct ff_pi;
extern struct ffuncstruct ff_e;
extern struct ffuncstruct ff_i;

extern struct ffuncstruct ff_error;

F_RF(fr_error);
F_CF(fc_error);
F_DF(fd_error);

#undef F_RF
#undef F_CF
#undef F_DF
