static char rcsid[] = "$Id: rmsmatch.c,v 1.2 1997/07/18 03:02:36 dhb Exp $";

/*
** $Log: rmsmatch.c,v $
** Revision 1.2  1997/07/18 03:02:36  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.1  1994/08/08 22:19:22  dhb
** Initial revision
**
 * Revision 1.1  1994/06/13  22:45:46  bhalla
 * Initial revision
**
*/


/*
** rms_match.c : for estimating the nearness of match of curves by
** doing a simple rms comparison. This is not useful for more complex
** curves like spike trains.
** By Upinder S. Bhalla, 1994, Mt Sinai
*/

#include <stdio.h>
#include <math.h>
#include "header.h"

float rmsmatch();


#define MAXSPKS 500
#define MIN_SHAPE_SAMPLES 8


float do_rmsmatch(argc,argv)
	int		argc;
	char	**argv;
{
	float match;
	int i;
	float *sim,*simt,*ref,*reft;
	int 	nsim,nref;
	int	status;
	float	Atof();
	int	userefindex = 0;
	int	usesimindex = 0;
	float refstart,refstop,simstart,simstop;
	int		auto_refstart = 1;
	int		auto_simstart = 1;

	initopt(argc, argv, "ref-file-or-table sim-file-or-table -refwindow t1 t2 -simwindow t1 t2 -userefindex -usesimindex");
	while ((status = G_getopt(argc, argv)) == 1)
	  {
	    if (strcmp(G_optopt, "-refwindow") == 0)
	      {
			refstart = Atof(optargv[1]);
			refstop = Atof(optargv[2]);
			auto_refstart = 0;
			if (refstart >= refstop) {
				Error();
				printf(
					"in rmsmatch, start=%g must be less than stop=%g\n",
					refstart,refstop);
				return(0.0);
			}
	      }
	    else if (strcmp(G_optopt, "-simwindow") == 0)
	      {
			simstart = Atof(optargv[1]);
			simstop = Atof(optargv[2]);
			auto_simstart = 0;
			if (simstart >= simstop) {
				Error();
				printf(
					"in rmsmatch, start=%g must be less than stop=%g\n",
					simstart,simstop);
				return(0.0);
			}
	      }
	    else if (strcmp(G_optopt, "-userefindex") == 0)
	      {
			userefindex = 1;
	      }
	    else if (strcmp(G_optopt, "-usesimindex") == 0)
	      {
			usesimindex = 1;
	      }
	  }

	if (status < 0) {
		printoptusage(argc, argv);
		return(0);
	}

	if ((nref = (load_file_or_table(optargv[1],&reft, &ref))) < 1)
		return(0);
	if ((nsim = (load_file_or_table(optargv[2],&simt, &sim))) < 1) {
		free(ref);
		free(reft);
		return(0);
	}
	nref--;
	nsim--;

	if (auto_refstart) {
		refstart = reft[0];
		refstop = reft[nref];
		userefindex = 0;
	}

	if (auto_simstart) {
		simstart = simt[0];
		simstop = simt[nsim];
		usesimindex = 0;
	}


	if (userefindex) { /* replace all reft entries with the index */
		for (i = 0; i <= nref; i++)
			reft[i] = i;
	}

	if (usesimindex) { /* replace all simt entries with the index */
		for (i = 0; i <= nsim; i++)
			simt[i] = i;
	}


	match=rmsmatch(ref,reft,nref,refstart,refstop,
			sim,simt,nsim,simstart,simstop);

	free(sim);
	free(simt);
	free(ref);
	free(reft);
	return(match);
}

/* This func calculates the rms difference between the ref and sim.
** It uses the sim time values, and uses linear interpolation
** between the ref values if needed.
*/
float rmsmatch(ref,reft,nref,refstart,refstop,
		sim,simt,nsim,simstart,simstop)
	float	*ref;
	float	*reft;
	int		nref;
	float	refstart,refstop;
	float	*sim;
	float	*simt;
	int		nsim;
	float	simstart,simstop;
{
	int		i;
	int 	j = 0;
	int		k;
	float 	simx,simy;
	double 	x;	/* x is the fraction of the range that has been done */
	float 	rtarget;
	float	refx = reft[0];
	float	nextrefx = reft[1];
	float	refy,nextrefy;
	double	y;
	double	sdy;
	double	rms = 0;
	int		nrms = 0;

	/* Note that i < nsim since we refer to i+1 in the loop */
	for(i = 0; i < nsim; i++) {
		simx = simt[i];
		if (simx > simstop) break;
		if (simx < simstart) continue;
		x = (simx - simstart)/(simstop - simstart);
		rtarget = refstart + x * (refstop - refstart);
		simy = sim[i];
		/* scan through refs to reach rtarget */
		while(refx <= rtarget) {
			if (nextrefx > rtarget) {
				refy = ref[j];
				nextrefy = ref[j+1];
				y = refy + (nextrefy - refy) *
					(rtarget - refx)/(nextrefx - refx);
				sdy = (y - simy) * (y - simy);
				rms += sdy;
				nrms++;
			}
			j++;
			if (j >= nref) break;
			refx = reft[j];
			nextrefx = reft[j+1];
		}
	}
	return((float)sqrt(rms/nrms));
}
