/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * integrate_local.h
 */

#ifndef _INTEGRATE_LOCAL_h_
#define _INTEGRATE_LOCAL_h_

/* ode_nstop.c */
int get_total_fstop( struct  Prop_DataS* integ_cntl );
int prop_fstop_init( struct Prop_DataS* prop_cntl, int* stop_action,
                     int* stop_status, double* current_state);
int prop_fstop_lift_test( struct  Prop_DataS* prop_cntl, int* stop_action,
                          int* stop_status, double* new, double* old, double* work );
int prop_fstop_test( struct  Prop_DataS* prop_cntl, int* stop_action,
                     int* stop_status, double* current_state );

int get_fstop_grp_entry( struct  Prop_DataS* integ_cntl, int index,
                         int* group, int* entry );

/* last_step.c */
int integ_last_step_lift( struct Prop_DataS* integ_cntl, double* initial_state, 
                          double* final_state, double stepsize,
                          int* stop_status, int* stop_action, double* workspace);
int integ_last_step( struct Prop_DataS* integ_cntl, double* initial_state, 
                     double* final_state, double stepsize,
                     int* stop_status, int* stop_action, double* workspace);



#endif
/* !_INTEGRATE_LOCAL_h_ */
