/*  -------------------------------------------------------------------

This program is the property of:

                             Cornell University 
                        Center for Applied Mathematics 
                              Ithaca, NY 14853

and may be used, modified and distributed freely, subject to the 
following restrictions:

       Any product which incorporates source code from the dstool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.

DsTool is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of FITNESS 
FOR A PARTICULAR PURPOSE.  The software is provided as is without 
any obligation on the part of Cornell faculty, staff or students to 
assist in its use, correction, modification or enhancement.

  -----------------------------------------------------------------  */
/*
 * periodic_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `periodic.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "periodic_ui.h"

/*
 * Initialize an instance of object `win'.
 */
periodic_win_objects *
periodic_win_objects_initialize(ip, owner)
	periodic_win_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (periodic_win_objects *) calloc(1, sizeof (periodic_win_objects))))
		return (periodic_win_objects *) NULL;
	if (!ip->win)
		ip->win = periodic_win_win_create(ip, owner);
	if (!ip->pan)
		ip->pan = periodic_win_pan_create(ip, ip->win);
	if (!ip->period)
		ip->period = periodic_win_period_create(ip, ip->pan);
	if (!ip->found)
		ip->found = periodic_win_found_create(ip, ip->pan);
	if (!ip->algorithm)
		ip->algorithm = periodic_win_algorithm_create(ip, ip->pan);
	if (!ip->guess)
		ip->guess = periodic_win_guess_create(ip, ip->pan);
	if (!ip->mc)
		ip->mc = periodic_win_mc_create(ip, ip->pan);
	if (!ip->show)
		ip->show = periodic_win_show_create(ip, ip->pan);
	if (!ip->reset)
		ip->reset = periodic_win_reset_create(ip, ip->pan);
	if (!ip->find)
		ip->find = periodic_win_find_create(ip, ip->pan);
	if (!ip->oneDman)
		ip->oneDman = periodic_win_oneDman_create(ip, ip->pan);
	if (!ip->twoDman)
		ip->twoDman = periodic_win_twoDman_create(ip, ip->pan);
	if (!ip->clear)
		ip->clear = periodic_win_clear_create(ip, ip->pan);
	if (!ip->clear_mans)
		ip->clear_mans = periodic_win_clear_mans_create(ip, ip->pan);
	if (!ip->periodic)
		ip->periodic = periodic_win_periodic_create(ip, ip->pan);
	if (!ip->fxpt_iters)
		ip->fxpt_iters = periodic_win_fxpt_iters_create(ip, ip->pan);
	if (!ip->duplicate)
		ip->duplicate = periodic_win_duplicate_create(ip, ip->pan);
	if (!ip->variable)
		ip->variable = periodic_win_variable_create(ip, ip->pan);
	if (!ip->function)
		ip->function = periodic_win_function_create(ip, ip->pan);
	if (!ip->fd_step)
		ip->fd_step = periodic_win_fd_step_create(ip, ip->pan);
	if (!ip->oneD)
		ip->oneD = periodic_win_oneD_create(ip, ip->pan);
	if (!ip->distance)
		ip->distance = periodic_win_distance_create(ip, ip->pan);
	if (!ip->stabpts)
		ip->stabpts = periodic_win_stabpts_create(ip, ip->pan);
	if (!ip->stabsteps)
		ip->stabsteps = periodic_win_stabsteps_create(ip, ip->pan);
	if (!ip->unstabpts)
		ip->unstabpts = periodic_win_unstabpts_create(ip, ip->pan);
	if (!ip->unstabsteps)
		ip->unstabsteps = periodic_win_unstabsteps_create(ip, ip->pan);
	if (!ip->twoD)
		ip->twoD = periodic_win_twoD_create(ip, ip->pan);
	if (!ip->NotImplemented)
		ip->NotImplemented = periodic_win_NotImplemented_create(ip, ip->pan);
	return ip;
}

/*
 * Create object `win' in the specified instance.

 */
Xv_opaque
periodic_win_win_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	void		periodic_done_proc();
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 378,
		XV_HEIGHT, 186,
		XV_LABEL, "Fixed Point",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_DONE_PROC, periodic_done_proc,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `pan' in the specified instance.

 */
Xv_opaque
periodic_win_pan_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `period' in the specified instance.

 */
Xv_opaque
periodic_win_period_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 16,
		XV_WIDTH, 169,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Period to Find:",
		PANEL_VALUE_X, 113,
		PANEL_VALUE_Y, 16,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `found' in the specified instance.

 */
Xv_opaque
periodic_win_found_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 246,
		XV_Y, 16,
		XV_WIDTH, 129,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "# Found:",
		PANEL_VALUE_X, 311,
		PANEL_VALUE_Y, 16,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `algorithm' in the specified instance.

 */
Xv_opaque
periodic_win_algorithm_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		periodic_setting_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 35,
		XV_WIDTH, 116,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 88,
		PANEL_VALUE_Y, 35,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Algorithm:",
		PANEL_NOTIFY_PROC, periodic_setting_notify,
		PANEL_CHOICE_STRINGS,
			"Newton's Method",
			"Secant Method",
			0,
		NULL);
	return obj;
}

/*
 * Create object `guess' in the specified instance.

 */
Xv_opaque
periodic_win_guess_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		periodic_setting_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 56,
		XV_WIDTH, 136,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 108,
		PANEL_VALUE_Y, 56,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Initial Guess:",
		PANEL_NOTIFY_PROC, periodic_setting_notify,
		PANEL_CHOICE_STRINGS,
			"Monte Carlo",
			"Selected Point",
			0,
		NULL);
	return obj;
}

/*
 * Create object `mc' in the specified instance.

 */
Xv_opaque
periodic_win_mc_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 246,
		XV_Y, 56,
		XV_WIDTH, 109,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "# MC:",
		PANEL_VALUE_X, 291,
		PANEL_VALUE_Y, 56,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `show' in the specified instance.

 */
Xv_opaque
periodic_win_show_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern int		periodic_setting_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 84,
		XV_WIDTH, 84,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 76,
		PANEL_VALUE_Y, 84,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Settings:",
		PANEL_NOTIFY_PROC, periodic_setting_notify,
		PANEL_CHOICE_STRINGS,
			"Hide",
			"Show",
			0,
		NULL);
	return obj;
}

/*
 * Create object `reset' in the specified instance.

 */
Xv_opaque
periodic_win_reset_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		periodic_reset_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 236,
		XV_Y, 88,
		XV_WIDTH, 51,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Reset",
		PANEL_NOTIFY_PROC, periodic_reset_notify,
		NULL);
	return obj;
}

/*
 * Create object `find' in the specified instance.

 */
Xv_opaque
periodic_win_find_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		periodic_find_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 128,
		XV_WIDTH, 45,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Find",
		PANEL_NOTIFY_PROC, periodic_find_notify,
		NULL);
	return obj;
}

/*
 * Create object `oneDman' in the specified instance.

 */
Xv_opaque
periodic_win_oneDman_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		periodic_oneDman_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 128,
		XV_WIDTH, 129,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Add 1-D Manifold",
		PANEL_NOTIFY_PROC, periodic_oneDman_notify,
		NULL);
	return obj;
}

/*
 * Create object `twoDman' in the specified instance.

 */
Xv_opaque
periodic_win_twoDman_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		periodic_twoDman_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 228,
		XV_Y, 128,
		XV_WIDTH, 129,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Add 2-D Manifold",
		PANEL_NOTIFY_PROC, periodic_twoDman_notify,
		NULL);
	return obj;
}

/*
 * Create object `clear' in the specified instance.

 */
Xv_opaque
periodic_win_clear_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		periodic_clear_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 156,
		XV_WIDTH, 50,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Clear",
		PANEL_NOTIFY_PROC, periodic_clear_notify,
		NULL);
	return obj;
}

/*
 * Create object `clear_mans' in the specified instance.

 */
Xv_opaque
periodic_win_clear_mans_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		periodic_clear_mans_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 156,
		XV_WIDTH, 114,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Clear Manifolds",
		PANEL_NOTIFY_PROC, periodic_clear_mans_notify,
		NULL);
	return obj;
}

/*
 * Create object `periodic' in the specified instance.

 */
Xv_opaque
periodic_win_periodic_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 200,
		XV_WIDTH, 228,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "Periodic Pt/Equilibria Tolerances",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `fxpt_iters' in the specified instance.

 */
Xv_opaque
periodic_win_fxpt_iters_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 224,
		XV_WIDTH, 220,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Number of Iterations:",
		PANEL_VALUE_X, 180,
		PANEL_VALUE_Y, 224,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `duplicate' in the specified instance.

 */
Xv_opaque
periodic_win_duplicate_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 244,
		XV_WIDTH, 189,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Duplicate Points:",
		PANEL_VALUE_X, 149,
		PANEL_VALUE_Y, 244,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `variable' in the specified instance.

 */
Xv_opaque
periodic_win_variable_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 264,
		XV_WIDTH, 176,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Minimum Step:",
		PANEL_VALUE_X, 136,
		PANEL_VALUE_Y, 264,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `function' in the specified instance.

 */
Xv_opaque
periodic_win_function_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 284,
		XV_WIDTH, 220,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Convergence Criterion:",
		PANEL_VALUE_X, 188,
		PANEL_VALUE_Y, 284,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `fd_step' in the specified instance.

 */
Xv_opaque
periodic_win_fd_step_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 304,
		XV_WIDTH, 226,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Finite Difference Step:",
		PANEL_VALUE_X, 186,
		PANEL_VALUE_Y, 304,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `oneD' in the specified instance.

 */
Xv_opaque
periodic_win_oneD_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 328,
		XV_WIDTH, 92,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "1-D Manifold",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `distance' in the specified instance.

 */
Xv_opaque
periodic_win_distance_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 28,
		XV_Y, 353,
		XV_WIDTH, 309,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Initial Distance Along Eigenvector:",
		PANEL_VALUE_X, 273,
		PANEL_VALUE_Y, 353,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `stabpts' in the specified instance.

 */
Xv_opaque
periodic_win_stabpts_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 28,
		XV_Y, 376,
		XV_WIDTH, 315,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Stable Manifold Divisions per Step:",
		PANEL_VALUE_X, 279,
		PANEL_VALUE_Y, 376,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `stabsteps' in the specified instance.

 */
Xv_opaque
periodic_win_stabsteps_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 152,
		XV_Y, 396,
		XV_WIDTH, 191,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Number of Steps:",
		PANEL_VALUE_X, 279,
		PANEL_VALUE_Y, 396,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `unstabpts' in the specified instance.

 */
Xv_opaque
periodic_win_unstabpts_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 28,
		XV_Y, 424,
		XV_WIDTH, 334,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Unstable Manifold Divisions per Step:",
		PANEL_VALUE_X, 298,
		PANEL_VALUE_Y, 424,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `unstabsteps' in the specified instance.

 */
Xv_opaque
periodic_win_unstabsteps_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	periodic_generic_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 172,
		XV_Y, 444,
		XV_WIDTH, 191,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Number of Steps:",
		PANEL_VALUE_X, 299,
		PANEL_VALUE_Y, 444,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_MAX_VALUE, 0,
		PANEL_MIN_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, periodic_generic_notify,
		NULL);
	return obj;
}

/*
 * Create object `twoD' in the specified instance.

 */
Xv_opaque
periodic_win_twoD_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 476,
		XV_WIDTH, 92,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "2-D Manifold",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `NotImplemented' in the specified instance.

 */
Xv_opaque
periodic_win_NotImplemented_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 28,
		XV_Y, 505,
		XV_WIDTH, 145,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "Not Yet Implemented",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

