/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no
representations about the suitability of this software for any purpose.  It
is provided "as is" without express or implied warranty.

*/

#include <errno.h>
#include <stdio.h>
#include "defs.h"

#define FIRSTWORD(word, str) (!strncmp(word, str, strlen(word)))

static char myLine[1024];

extern char *ignoreList[];
extern int useIgnore;
extern char *retainList[];
extern char *StepOverWhiteSpace();
extern int useRetain,  debug;
extern char *MAILRC;



char *expandLine(tmp2)
char *tmp2;
{
int x,y;

	for(x=0,y=0;x<strlen(tmp2);x++,y++)
	{
		if(tmp2[x]=='\\')
		{
			x++;
			switch((int)tmp2[x])
			{
				case (int)'n':
					myLine[y]='\n';
					break;
				case (int)'r':
					myLine[y]='\r';
					break;
				case (int)'t':
					myLine[y]='\t';
					break;
				case (int)'b':
					myLine[y]='\b';
					break;
				default:
					myLine[y]=tmp2[x];
					break;
			}
		}
		else
		{
			myLine[y]=tmp2[x];
		}
	}
	return(myLine);
}

char *getLine(mF)
FILE *mF;
{
int x=0,y=0,first;
char tmp1_buff[1024],*tmp1,*tmp2=myLine;

	for(first=1;;)
	{
		if(fgets(tmp1_buff,1024,mF)==NULL)
		{
			if(first)
				return((char *)0);
			break;
		}
		tmp1=StepOverWhiteSpace(tmp1_buff);
		if(tmp1[strlen(tmp1)-2]!='\\')
		{
			if((!first) && (tmp1[0]!='\n'))
				strncpy(&tmp2[x++]," ",1);

			strncpy(&tmp2[x],tmp1,strlen(tmp1)-1);
			x+=strlen(tmp1)-1;
			tmp2[x]=(char)0;
			break;
		}
		if(!first && (tmp1[0]!='\n'))
			strncpy(&tmp2[x++]," ",1);


		strncpy(&tmp2[x],tmp1,strlen(tmp1)-2);

		x+=strlen(tmp1)-2;
		tmp2[x]=(char)0;
		first=0;
	}

	return(myLine);
}

int
setHandler(ln)
char *ln;
{
/*
 * make a call to something in vars.c to handle interpreting
 * this line.
 */
setvars(ln);
}

int
aliasHandler(ln)
char *ln;
{

setaliases(ln);
/*
 * make a call to something in aliases.c to handle interpreting
 * this line.
 */
}

int
ignoreHandler(ln)
char *ln;
{
	setupIgnoreRetain(ignoreList,ln);
	useRetain=0;
	useIgnore=1;
}

int
retainHandler(ln)
char *ln;
{
	setupIgnoreRetain(retainList,ln);
	useRetain=1;
	useIgnore=0;
}

int
readMailrcFile(mailrc_file)
char *mailrc_file;
{
char *this_line;
char *tmp_fname;
FILE *mailrcFile;
char fname[1024];

	if(mailrc_file==(char *)0)
		strcpy(fname,MAILRC);
	else
		strcpy(fname,mailrc_file);

	tmp_fname=(char *)expand_value(fname,1);

	if((mailrcFile=fopen(tmp_fname,"r"))==NULL)
	{
		if(errno==ENOENT)
		{
			free(tmp_fname);
			return(0);
		}
		else
		{
			perror(tmp_fname);
			free(tmp_fname);
			return(-1);
		}
	}

	free(tmp_fname);

	for(;;)
	{
		this_line=getLine(mailrcFile);

		if(this_line==NULL)
			return(0);
		if((this_line[0]==(char)0) || (this_line[0]=='#'))
			continue;

		if(FIRSTWORD("set", this_line))
		{
			setHandler(
				&this_line[4+strspn(&this_line[4]," \t")]);
		}
		else if(FIRSTWORD("alias", this_line))
		{
			aliasHandler(
				&this_line[6+strspn(&this_line[6]," \t")]);
		}
		else if(FIRSTWORD("ignore", this_line))
		{
			ignoreHandler(
				&this_line[7+strspn(&this_line[7]," \t")]);
		}
		else if(FIRSTWORD("retain", this_line))
		{
			retainHandler(
				&this_line[7+strspn(&this_line[7]," \t")]);
		}
		else if(FIRSTWORD("cd", this_line))
		{
		char *dir_name;
			dir_name=(char *)expand_value(
				&this_line[2+strspn(&this_line[2]," \t")],1);

			if(strlen(dir_name)==0)
			{
				chdir((char *)getenv("HOME"));
			}
			else if(chdir(dir_name)==-1)
			{
				perror(dir_name);
			}
			if(debug)
				fprintf(stderr,"CWD = %s %s\n",dir_name,
#if defined(SYSV) || defined(__alpha)
					getcwd(fname,1024)
#else
					getwd(fname)
#endif
							);
			free(dir_name);
		}
		else if(debug)
			fprintf(stderr,"LINE = [%s]\n",this_line);
	}
}





